/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.dynamometer;

import java.util.regex.Pattern;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.tools.dynamometer.DynoResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class DynoConstants {
    public static final String DYNAMOMETER_STORAGE_DIR = ".dynamometer";
    public static final DynoResource CONF_ZIP = new DynoResource("CONF_ZIP", LocalResourceType.ARCHIVE, "conf");
    public static final DynoResource HADOOP_BINARY = new DynoResource("HADOOP_BINARY", LocalResourceType.ARCHIVE, "hadoopBinary");
    public static final DynoResource START_SCRIPT = new DynoResource("START_SCRIPT", LocalResourceType.FILE, "start-component.sh");
    public static final DynoResource FS_IMAGE = new DynoResource("FS_IMAGE", LocalResourceType.FILE, null);
    public static final DynoResource FS_IMAGE_MD5 = new DynoResource("FS_IMAGE_MD5", LocalResourceType.FILE, null);
    public static final DynoResource VERSION = new DynoResource("VERSION", LocalResourceType.FILE, "VERSION");
    public static final DynoResource DYNO_DEPENDENCIES = new DynoResource("DYNO_DEPS", LocalResourceType.ARCHIVE, "dependencies");
    public static final String BLOCK_LIST_PATH_ENV = "BLOCK_ZIP_PATH";
    public static final Pattern BLOCK_LIST_FILE_PATTERN = Pattern.compile("dn[0-9]+-a-[0-9]+-r-[0-9]+");
    public static final String BLOCK_LIST_RESOURCE_PATH_PREFIX = "blocks/block";
    public static final PathFilter BLOCK_LIST_FILE_FILTER = path -> BLOCK_LIST_FILE_PATTERN.matcher(path.getName()).find();
    public static final String REMOTE_STORAGE_PATH_ENV = "REMOTE_STORAGE_PATH";
    public static final String REMOTE_NN_RPC_ADDR_ENV = "REMOTE_NN_RPC_ADDR";
    public static final String JOB_ACL_VIEW_ENV = "JOB_ACL_VIEW";
    public static final String NN_INFO_FILE_NAME = "nn_info.prop";
    public static final String NN_ADDITIONAL_ARGS_ENV = "NN_ADDITIONAL_ARGS";
    public static final String DN_ADDITIONAL_ARGS_ENV = "DN_ADDITIONAL_ARGS";
    public static final String NN_NAME_DIR_ENV = "NN_NAME_DIR";
    public static final String NN_EDITS_DIR_ENV = "NN_EDITS_DIR";
    public static final String NN_FILE_METRIC_PERIOD_ENV = "NN_FILE_METRIC_PERIOD";
    public static final String NN_RPC_PORT = "NN_RPC_PORT";
    public static final String NN_HOSTNAME = "NN_HOSTNAME";
    public static final String NN_SERVICERPC_PORT = "NN_SERVICERPC_PORT";
    public static final String NN_HTTP_PORT = "NN_HTTP_PORT";

    private DynoConstants() {
    }
}

