/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.uuid.EthernetAddress;
import com.fasterxml.uuid.Generators;
import com.fasterxml.uuid.impl.TimeBasedGenerator;
import com.microsoft.azure.cosmosdb.ConsistencyLevel;
import com.microsoft.azure.cosmosdb.DocumentCollection;
import com.microsoft.azure.cosmosdb.internal.OperationType;
import com.microsoft.azure.cosmosdb.internal.ResourceId;
import com.microsoft.azure.cosmosdb.internal.ResourceType;
import com.microsoft.azure.cosmosdb.internal.RuntimeConstants;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;

public final class Utils {
    private static final ZoneId GMT_ZONE_ID = ZoneId.of("GMT");
    public static final Base64.Encoder Base64Encoder = Base64.getEncoder();
    public static final Base64.Decoder Base64Decoder = Base64.getDecoder();
    private static final ObjectMapper simpleObjectMapper = new ObjectMapper();
    private static final TimeBasedGenerator TimeUUIDGegerator = Generators.timeBasedGenerator((EthernetAddress)EthernetAddress.constructMulticastAddress());
    private static final DateTimeFormatter RFC_1123_DATE_TIME = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);

    public static byte[] getUTF8Bytes(String str) throws UnsupportedEncodingException {
        return str.getBytes("UTF-8");
    }

    public static String encodeBase64String(byte[] binaryData) {
        String encodedString = Base64Encoder.encodeToString(binaryData);
        if (encodedString.endsWith("\r\n")) {
            encodedString = encodedString.substring(0, encodedString.length() - 2);
        }
        return encodedString;
    }

    public static boolean isNameBased(String link) {
        String[] parts;
        if (StringUtils.isEmpty((CharSequence)link)) {
            return false;
        }
        if (link.startsWith("/") && link.length() > 1) {
            link = link.substring(1);
        }
        if ((parts = StringUtils.split((String)link, (String)"/")).length == 0 || StringUtils.isEmpty((CharSequence)parts[0]) || !parts[0].equalsIgnoreCase("dbs")) {
            return false;
        }
        if (parts.length < 2 || StringUtils.isEmpty((CharSequence)parts[1])) {
            return false;
        }
        String databaseID = parts[1];
        if (databaseID.length() != 8) {
            return true;
        }
        byte[] buffer = ResourceId.fromBase64String(databaseID);
        return buffer.length != 4;
    }

    public static boolean isDatabaseLink(String link) {
        if (StringUtils.isEmpty((CharSequence)link)) {
            return false;
        }
        String[] parts = StringUtils.split((String)(link = Utils.trimBeginningAndEndingSlashes(link)), (String)"/");
        if (parts.length != 2) {
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)parts[0]) || !parts[0].equalsIgnoreCase("dbs")) {
            return false;
        }
        return !StringUtils.isEmpty((CharSequence)parts[1]);
    }

    public static boolean IsResourceType(String resourcePathSegment) {
        if (StringUtils.isEmpty((CharSequence)resourcePathSegment)) {
            return false;
        }
        switch (resourcePathSegment.toLowerCase()) {
            case "attachments": 
            case "colls": 
            case "dbs": 
            case "permissions": 
            case "users": 
            case "docs": 
            case "sprocs": 
            case "triggers": 
            case "udfs": 
            case "conflicts": 
            case "pkranges": {
                return true;
            }
        }
        return false;
    }

    public static String joinPath(String path1, String path2) {
        path1 = Utils.trimBeginningAndEndingSlashes(path1);
        String result = "/" + path1 + "/";
        if (!StringUtils.isEmpty((CharSequence)path2)) {
            path2 = Utils.trimBeginningAndEndingSlashes(path2);
            result = result + path2 + "/";
        }
        return result;
    }

    public static String trimBeginningAndEndingSlashes(String path) {
        if (path == null) {
            return null;
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static Map<String, String> paramEncode(Map<String, String> queryParams) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<String, String> paramEntry : queryParams.entrySet()) {
            try {
                map.put(paramEntry.getKey(), URLEncoder.encode(paramEntry.getValue(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
        }
        return map;
    }

    public static String createQuery(Map<String, String> queryParameters) {
        if (queryParameters == null) {
            return "";
        }
        StringBuilder queryString = new StringBuilder();
        for (Map.Entry<String, String> nameValuePair : queryParameters.entrySet()) {
            String key = nameValuePair.getKey();
            String value = nameValuePair.getValue();
            if (key == null || key.isEmpty()) continue;
            if (queryString.length() > 0) {
                queryString.append(RuntimeConstants.Separators.Query[1]);
            }
            queryString.append(key);
            if (value == null) continue;
            queryString.append(RuntimeConstants.Separators.Query[2]);
            queryString.append(value);
        }
        return queryString.toString();
    }

    public static URL setQuery(String urlString, String query) {
        if (urlString == null) {
            throw new IllegalStateException("urlString parameter can't be null.");
        }
        query = Utils.removeLeadingQuestionMark(query);
        try {
            if (query != null && !query.isEmpty()) {
                return new URI(Utils.addTrailingSlash(urlString) + RuntimeConstants.Separators.Query[0] + query).toURL();
            }
            return new URI(Utils.addTrailingSlash(urlString)).toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Uri is invalid: ", e);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Uri is invalid: ", e);
        }
    }

    public static String getCollectionName(String resourceFullName) {
        if (resourceFullName != null) {
            resourceFullName = Utils.trimBeginningAndEndingSlashes(resourceFullName);
            int slashCount = 0;
            for (int i = 0; i < resourceFullName.length(); ++i) {
                if (resourceFullName.charAt(i) != '/' || ++slashCount != 4) continue;
                return resourceFullName.substring(0, i);
            }
        }
        return resourceFullName;
    }

    public static Boolean isCollectionPartitioned(DocumentCollection collection) {
        if (collection == null) {
            throw new IllegalArgumentException("collection");
        }
        return collection.getPartitionKey() != null && collection.getPartitionKey().getPaths() != null && collection.getPartitionKey().getPaths().size() > 0;
    }

    public static boolean isCollectionChild(ResourceType type) {
        return type == ResourceType.Document || type == ResourceType.Attachment || type == ResourceType.Conflict || type == ResourceType.StoredProcedure || type == ResourceType.Trigger || type == ResourceType.UserDefinedFunction;
    }

    public static boolean isWriteOperation(OperationType operationType) {
        return operationType == OperationType.Create || operationType == OperationType.Upsert || operationType == OperationType.Delete || operationType == OperationType.Replace || operationType == OperationType.ExecuteJavaScript;
    }

    public static boolean isFeedRequest(OperationType requestOperationType) {
        return requestOperationType == OperationType.Create || requestOperationType == OperationType.Upsert || requestOperationType == OperationType.ReadFeed || requestOperationType == OperationType.Query || requestOperationType == OperationType.SqlQuery || requestOperationType == OperationType.HeadFeed;
    }

    private static String addTrailingSlash(String path) {
        if (path == null || path.isEmpty()) {
            path = new String(RuntimeConstants.Separators.Url);
        } else if (path.charAt(path.length() - 1) != RuntimeConstants.Separators.Url[0]) {
            path = path + RuntimeConstants.Separators.Url[0];
        }
        return path;
    }

    private static String removeLeadingQuestionMark(String path) {
        if (path == null || path.isEmpty()) {
            return path;
        }
        if (path.charAt(0) == RuntimeConstants.Separators.Query[0]) {
            return path.substring(1);
        }
        return path;
    }

    public static boolean isValidConsistency(ConsistencyLevel backendConsistency, ConsistencyLevel desiredConsistency) {
        switch (backendConsistency) {
            case Strong: {
                return desiredConsistency == ConsistencyLevel.Strong || desiredConsistency == ConsistencyLevel.BoundedStaleness || desiredConsistency == ConsistencyLevel.Session || desiredConsistency == ConsistencyLevel.Eventual || desiredConsistency == ConsistencyLevel.ConsistentPrefix;
            }
            case BoundedStaleness: {
                return desiredConsistency == ConsistencyLevel.BoundedStaleness || desiredConsistency == ConsistencyLevel.Session || desiredConsistency == ConsistencyLevel.Eventual || desiredConsistency == ConsistencyLevel.ConsistentPrefix;
            }
            case Session: 
            case Eventual: 
            case ConsistentPrefix: {
                return desiredConsistency == ConsistencyLevel.Session || desiredConsistency == ConsistencyLevel.Eventual || desiredConsistency == ConsistencyLevel.ConsistentPrefix;
            }
        }
        throw new IllegalArgumentException("backendConsistency");
    }

    public static String getUserAgent(String sdkName, String sdkVersion) {
        String osName = System.getProperty("os.name");
        if (osName == null) {
            osName = "Unknown";
        }
        osName = osName.replaceAll("\\s", "");
        String userAgent = String.format("%s/%s JRE/%s %s/%s", osName, System.getProperty("os.version"), System.getProperty("java.version"), sdkName, sdkVersion);
        return userAgent;
    }

    public static ObjectMapper getSimpleObjectMapper() {
        return simpleObjectMapper;
    }

    public static String nowAsRFC1123() {
        ZonedDateTime now = ZonedDateTime.now(GMT_ZONE_ID);
        return RFC_1123_DATE_TIME.format(now);
    }

    public static UUID randomUUID() {
        return TimeUUIDGegerator.generate();
    }

    public static String zonedDateTimeAsUTCRFC1123(ZonedDateTime zonedDateTime) {
        return RFC_1123_DATE_TIME.format(zonedDateTime.withZoneSameInstant(GMT_ZONE_ID));
    }

    static {
        simpleObjectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        simpleObjectMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        simpleObjectMapper.configure(JsonParser.Feature.ALLOW_TRAILING_COMMA, true);
        simpleObjectMapper.configure(JsonParser.Feature.STRICT_DUPLICATE_DETECTION, true);
    }
}

