/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.fpga.discovery;

import java.util.List;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.fpga.FpgaDevice;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.fpga.discovery.DeviceSpecParser;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.fpga.discovery.FPGADiscoveryStrategy;

public class SettingsBasedFPGADiscoveryStrategy
implements FPGADiscoveryStrategy {
    private final String type;
    private final String availableDevices;

    public SettingsBasedFPGADiscoveryStrategy(String fpgaType, String devices) {
        this.type = fpgaType;
        this.availableDevices = devices;
    }

    @Override
    public List<FpgaDevice> discover() throws ResourceHandlerException {
        List<FpgaDevice> list = DeviceSpecParser.getDevicesFromString(this.type, this.availableDevices);
        if (list.isEmpty()) {
            throw new ResourceHandlerException("No FPGA devices were specified");
        }
        return list;
    }
}

