/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.applications.mawo.server.common;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.hadoop.applications.mawo.server.common.TaskId;
import org.apache.hadoop.applications.mawo.server.worker.WorkerId;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskStatus
implements Writable,
Cloneable {
    private static final Logger LOG = LoggerFactory.getLogger(TaskStatus.class);
    private TaskId taskId = new TaskId();
    private long startTime;
    private long endTime;
    private WorkerId workerId = new WorkerId();
    private int exitCode = -1;
    private String taskCMD;
    private String taskType;
    private volatile State runState;

    public TaskStatus() {
    }

    public TaskStatus(WorkerId localworkerId, TaskId localtaskId, String localtaskCMD, String localtaskType) {
        this(localworkerId, localtaskId, State.INIT, localtaskCMD, localtaskType);
    }

    public TaskStatus(WorkerId localworkerId, TaskId localtaskId, State localrunState, String localtaskCMD, String localtaskType) {
        this.setWorkerId(localworkerId);
        this.setTaskId(localtaskId);
        this.setRunState(localrunState);
        this.setTaskCMD(localtaskCMD);
        this.setTaskType(localtaskType);
    }

    public final State getRunState() {
        return this.runState;
    }

    public final void setRunState(State localrunState) {
        this.runState = localrunState;
    }

    public final void setExitCode(int localexitCode) {
        this.exitCode = localexitCode;
    }

    public final int getExitCode() {
        return this.exitCode;
    }

    public final void setTaskCMD(String localcmd) {
        this.taskCMD = localcmd;
    }

    public final String getTaskCMD() {
        return this.taskCMD;
    }

    public final void setTaskType(String localtaskType) {
        this.taskType = localtaskType;
    }

    public final String getTaskType() {
        return this.taskType;
    }

    public final TaskId getTaskId() {
        return this.taskId;
    }

    public final void setTaskId(TaskId localtaskId) {
        if (localtaskId != null) {
            this.taskId = localtaskId;
        }
    }

    public final void setTaskState(TaskId localtaskId, State localrunState) {
        this.setTaskId(localtaskId);
        this.setRunState(localrunState);
    }

    public final State getTaskState(TaskId localtaskId) {
        if (localtaskId.equals(this.taskId)) {
            return this.getRunState();
        }
        return null;
    }

    public final long getStartTime() {
        return this.startTime;
    }

    public final void setStartTime() {
        this.startTime = this.getCurrentTime();
        LOG.debug("Start Time for " + this.taskId + " is " + this.startTime);
    }

    private void setStartTime(long time) {
        this.startTime = time;
    }

    public final long getEndTime() {
        return this.endTime;
    }

    public final void setEndTime() {
        this.setEndTime(this.getCurrentTime());
    }

    private void setEndTime(long time) {
        this.endTime = time;
        LOG.debug("End Time for " + this.taskId + " is " + this.endTime);
    }

    private long getCurrentTime() {
        return System.currentTimeMillis();
    }

    public final void write(DataOutput dataOutput) throws IOException {
        this.workerId.write(dataOutput);
        this.taskId.write(dataOutput);
        WritableUtils.writeEnum((DataOutput)dataOutput, (Enum)this.runState);
        WritableUtils.writeVLong((DataOutput)dataOutput, (long)this.getStartTime());
        WritableUtils.writeVLong((DataOutput)dataOutput, (long)this.getEndTime());
        WritableUtils.writeString((DataOutput)dataOutput, (String)this.taskCMD);
        WritableUtils.writeString((DataOutput)dataOutput, (String)this.taskType);
        WritableUtils.writeVInt((DataOutput)dataOutput, (int)this.exitCode);
    }

    public final void readFields(DataInput dataInput) throws IOException {
        this.workerId.readFields(dataInput);
        this.taskId.readFields(dataInput);
        this.setRunState((State)WritableUtils.readEnum((DataInput)dataInput, State.class));
        this.setStartTime(WritableUtils.readVLong((DataInput)dataInput));
        this.setEndTime(WritableUtils.readVLong((DataInput)dataInput));
        this.setTaskCMD(WritableUtils.readString((DataInput)dataInput));
        this.setTaskType(WritableUtils.readString((DataInput)dataInput));
        this.setExitCode(WritableUtils.readVInt((DataInput)dataInput));
    }

    public final WorkerId getWorkerId() {
        return this.workerId;
    }

    public final void setWorkerId(WorkerId localworkerId) {
        this.workerId = localworkerId;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        TaskStatus other = (TaskStatus)obj;
        return this.getWorkerId().equals(other.getWorkerId()) && this.getTaskId().equals(other.getTaskId()) && this.getRunState().equals((Object)other.getRunState()) && this.getStartTime() == other.getStartTime() && this.getEndTime() == other.getEndTime() && this.getTaskCMD().equals(other.getTaskCMD()) && this.getTaskType().equals(other.getTaskType()) && this.getExitCode() == other.getExitCode();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getWorkerId()).append((Object)this.getTaskId()).append((Object)this.getRunState()).append(this.getStartTime()).append(this.getEndTime()).append((Object)this.getTaskCMD()).append((Object)this.getTaskType()).append(this.getExitCode());
        return builder.hashCode();
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public static enum State {
        INIT,
        RUNNING,
        SUCCEEDED,
        FAILED,
        KILLED,
        EXPIRE;

    }
}

