/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.csi.client;

import csi.v0.ControllerGrpc;
import csi.v0.IdentityGrpc;
import csi.v0.NodeGrpc;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.netty.NettyChannelBuilder;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollDomainSocketChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CsiGrpcClient
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(CsiGrpcClient.class);
    private final ManagedChannel channel;

    private CsiGrpcClient(ManagedChannel channel) {
        this.channel = channel;
    }

    public static GrpcClientBuilder newBuilder() {
        return new GrpcClientBuilder();
    }

    @Override
    public void close() {
        try {
            this.channel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOG.error("Failed to gracefully shutdown gRPC communication channel in 5 seconds", (Throwable)e);
        }
    }

    public IdentityGrpc.IdentityBlockingStub createIdentityBlockingStub() {
        return IdentityGrpc.newBlockingStub((Channel)this.channel);
    }

    public ControllerGrpc.ControllerBlockingStub createControllerBlockingStub() {
        return ControllerGrpc.newBlockingStub((Channel)this.channel);
    }

    public NodeGrpc.NodeBlockingStub createNodeBlockingStub() {
        return NodeGrpc.newBlockingStub((Channel)this.channel);
    }

    public static class GrpcClientBuilder {
        private SocketAddress socket;

        public GrpcClientBuilder setDomainSocketAddress(SocketAddress address) {
            this.socket = address;
            return this;
        }

        private ManagedChannel getChannel(SocketAddress socketAddress) throws IOException {
            DefaultThreadFactory tf = new DefaultThreadFactory("yarn-csi-client-", true);
            EpollEventLoopGroup loopGroup = new EpollEventLoopGroup(0, (ThreadFactory)tf);
            if (socketAddress instanceof DomainSocketAddress) {
                ManagedChannel channel = NettyChannelBuilder.forAddress((SocketAddress)socketAddress).channelType(EpollDomainSocketChannel.class).eventLoopGroup((EventLoopGroup)loopGroup).usePlaintext().build();
                return channel;
            }
            throw new IOException("Currently only unix domain socket is supported");
        }

        public CsiGrpcClient build() throws IOException {
            ManagedChannel socketChannel = this.getChannel(this.socket);
            return new CsiGrpcClient(socketChannel);
        }
    }
}

