/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl;

import java.net.URI;
import javax.annotation.Nullable;
import org.apache.hadoop.fs.PathIOException;

public class InstantiationIOException
extends PathIOException {
    public static final String ABSTRACT_PROVIDER = "is abstract and therefore cannot be created";
    public static final String CONSTRUCTOR_EXCEPTION = "constructor exception";
    public static final String INSTANTIATION_EXCEPTION = "instantiation exception";
    public static final String DOES_NOT_IMPLEMENT = "does not implement";
    private final Kind kind;
    private final String classname;
    private final String key;

    public InstantiationIOException(Kind kind, @Nullable URI uri, @Nullable String classname, @Nullable String key, String message, @Nullable Throwable cause) {
        super(uri != null ? uri.toString() : "", (classname != null ? "Class " + classname + " " : "") + message + (key != null ? " (configuration key " + key + ")" : ""), cause);
        this.kind = kind;
        this.classname = classname;
        this.key = key;
    }

    public String getClassname() {
        return this.classname;
    }

    public Kind getKind() {
        return this.kind;
    }

    public String getKey() {
        return this.key;
    }

    public static InstantiationIOException isAbstract(URI uri, String classname, String key) {
        return new InstantiationIOException(Kind.IsAbstract, uri, classname, key, ABSTRACT_PROVIDER, null);
    }

    public static InstantiationIOException isNotInstanceOf(@Nullable URI uri, String classname, String interfaceName, String key) {
        return new InstantiationIOException(Kind.IsNotImplementation, uri, classname, key, "does not implement " + interfaceName, null);
    }

    public static InstantiationIOException unavailable(@Nullable URI uri, @Nullable String classname, @Nullable String key, String text) {
        return new InstantiationIOException(Kind.Unavailable, uri, classname, key, text, null);
    }

    public static InstantiationIOException unsupportedConstructor(@Nullable URI uri, String classname, String key) {
        return new InstantiationIOException(Kind.UnsupportedConstructor, uri, classname, key, CONSTRUCTOR_EXCEPTION, null);
    }

    public static InstantiationIOException instantiationException(@Nullable URI uri, String classname, String key, Throwable t) {
        return new InstantiationIOException(Kind.InstantiationFailure, uri, classname, key, "instantiation exception " + t, t);
    }

    public static enum Kind {
        Forbidden,
        InstantiationFailure,
        IsAbstract,
        IsNotImplementation,
        Other,
        Unavailable,
        UnsupportedConstructor;

    }
}

