/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.internal.operators;

import com.github.davidmoten.rx.buffertofile.DataSerializer;
import com.github.davidmoten.rx.buffertofile.Options;
import com.github.davidmoten.rx.internal.operators.FileBasedSPSCQueue;
import com.github.davidmoten.rx.internal.operators.FileBasedSPSCQueueMemoryMapped;
import com.github.davidmoten.rx.internal.operators.NullSentinel;
import com.github.davidmoten.rx.internal.operators.QueueWithResources;
import com.github.davidmoten.rx.internal.operators.QueueWithResourcesNonBlockingUnsubscribe;
import com.github.davidmoten.rx.internal.operators.QueueWithSubscription;
import com.github.davidmoten.rx.internal.operators.RollingSPSCQueue;
import com.github.davidmoten.util.Preconditions;
import java.io.File;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.Producer;
import rx.Scheduler;
import rx.Subscriber;
import rx.Subscription;
import rx.exceptions.Exceptions;
import rx.functions.Action0;
import rx.functions.Func0;
import rx.internal.operators.BackpressureUtils;
import rx.observers.Subscribers;

public final class OperatorBufferToFile<T>
implements Observable.Operator<T, T> {
    private final DataSerializer<T> dataSerializer;
    private final Scheduler scheduler;
    private final Options options;
    private static final boolean MEMORY_MAPPED = "true".equals(System.getProperty("memory.mappped"));

    public OperatorBufferToFile(DataSerializer<T> dataSerializer, Scheduler scheduler, Options options) {
        Preconditions.checkNotNull(dataSerializer);
        Preconditions.checkNotNull(scheduler);
        Preconditions.checkNotNull(options);
        this.scheduler = scheduler;
        this.dataSerializer = dataSerializer;
        this.options = options;
    }

    public Subscriber<? super T> call(Subscriber<? super T> child) {
        QueueWithSubscription<T> queue = OperatorBufferToFile.createFileBasedQueue(this.dataSerializer, this.options);
        AtomicReference queueProducer = new AtomicReference();
        Scheduler.Worker worker = this.scheduler.createWorker();
        Observable source = Observable.create(new OnSubscribeFromQueue(queueProducer, queue, worker, this.options));
        ParentSubscriber parentSubscriber = new ParentSubscriber(queueProducer);
        child.add(parentSubscriber);
        child.add(queue);
        Subscriber wrappedChild = Subscribers.wrap(child);
        child.add((Subscription)worker);
        source.unsafeSubscribe(wrappedChild);
        return parentSubscriber;
    }

    private static <T> QueueWithSubscription<T> createFileBasedQueue(final DataSerializer<T> dataSerializer, final Options options) {
        if (MEMORY_MAPPED) {
            int size = options.rolloverSizeBytes() > Integer.MAX_VALUE ? 0x1400000 : (int)options.rolloverSizeBytes();
            return new FileBasedSPSCQueueMemoryMapped<T>(options.fileFactory(), size, dataSerializer);
        }
        if (options.rolloverEvery() == Long.MAX_VALUE && options.rolloverSizeBytes() == Long.MAX_VALUE) {
            return new QueueWithResourcesNonBlockingUnsubscribe<T>(new FileBasedSPSCQueue<T>(options.bufferSizeBytes(), (File)options.fileFactory().call(), dataSerializer));
        }
        Func0 queueFactory = new Func0<QueueWithResources<T>>(){

            public QueueWithResources<T> call() {
                File file = (File)options.fileFactory().call();
                return new FileBasedSPSCQueue(options.bufferSizeBytes(), file, dataSerializer);
            }
        };
        return new QueueWithResourcesNonBlockingUnsubscribe(new RollingSPSCQueue(queueFactory, options.rolloverSizeBytes(), options.rolloverEvery()));
    }

    private static final class QueueProducer<T>
    extends AtomicLong
    implements Producer,
    Action0 {
        private static final long serialVersionUID = 2521533710633950102L;
        private final QueueWithSubscription<T> queue;
        private final AtomicInteger drainRequested = new AtomicInteger(0);
        private final Subscriber<? super T> child;
        private final Scheduler.Worker worker;
        private final boolean delayError;
        private volatile boolean done;
        private Throwable error = null;

        QueueProducer(QueueWithSubscription<T> queue, Subscriber<? super T> child, Scheduler.Worker worker, boolean delayError) {
            this.queue = queue;
            this.child = child;
            this.worker = worker;
            this.delayError = delayError;
            this.done = false;
        }

        void onNext(T t) {
            try {
                if (!this.queue.offer(t)) {
                    this.onError(new RuntimeException("could not place item on queue (queue.offer(item) returned false), item= " + t));
                    return;
                }
                this.drain();
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal((Throwable)e);
                this.onError(e);
            }
        }

        void onError(Throwable e) {
            this.error = e;
            this.done = true;
            this.drain();
        }

        void onCompleted() {
            this.done = true;
            this.drain();
        }

        public void request(long n) {
            if (n > 0L) {
                BackpressureUtils.getAndAddRequest((AtomicLong)this, (long)n);
                this.drain();
            }
        }

        private void drain() {
            if (!this.child.isUnsubscribed() && this.drainRequested.getAndIncrement() == 0) {
                this.worker.schedule((Action0)this);
            }
        }

        public void call() {
            try {
                this.drainNow();
            }
            catch (Throwable e) {
                this.child.onError(e);
            }
        }

        private void drainNow() {
            if (this.child.isUnsubscribed()) {
                return;
            }
            long requests = this.get();
            do {
                long emitted;
                this.drainRequested.set(1);
                for (emitted = 0L; emitted < requests; ++emitted) {
                    if (this.child.isUnsubscribed()) {
                        return;
                    }
                    Object item = this.queue.poll();
                    if (item == null) {
                        if (!this.finished()) break;
                        return;
                    }
                    if (NullSentinel.isNullSentinel(item)) {
                        this.child.onNext(null);
                        continue;
                    }
                    this.child.onNext(item);
                }
                requests = BackpressureUtils.produced((AtomicLong)this, (long)emitted);
            } while (!this.child.isUnsubscribed() && (requests != 0L || !this.finished()));
        }

        private boolean finished() {
            if (this.done) {
                Throwable t = this.error;
                if (this.queue.isEmpty()) {
                    this.queue.unsubscribe();
                    if (t != null) {
                        this.child.onError(t);
                    } else {
                        this.child.onCompleted();
                    }
                    return true;
                }
                if (t != null && !this.delayError) {
                    this.queue.unsubscribe();
                    this.child.onError(t);
                    return true;
                }
                return this.drainRequested.compareAndSet(1, 0);
            }
            return this.drainRequested.compareAndSet(1, 0);
        }
    }

    private static final class ParentSubscriber<T>
    extends Subscriber<T> {
        private final AtomicReference<QueueProducer<T>> queueProducer;

        ParentSubscriber(AtomicReference<QueueProducer<T>> queueProducer) {
            this.queueProducer = queueProducer;
        }

        public void onStart() {
            this.request(Long.MAX_VALUE);
        }

        public void onCompleted() {
            this.queueProducer.get().onCompleted();
        }

        public void onError(Throwable e) {
            this.queueProducer.get().onError(e);
        }

        public void onNext(T t) {
            this.queueProducer.get().onNext(t);
        }
    }

    private static final class OnSubscribeFromQueue<T>
    implements Observable.OnSubscribe<T> {
        private final AtomicReference<QueueProducer<T>> queueProducer;
        private final QueueWithSubscription<T> queue;
        private final Scheduler.Worker worker;
        private final Options options;

        OnSubscribeFromQueue(AtomicReference<QueueProducer<T>> queueProducer, QueueWithSubscription<T> queue, Scheduler.Worker worker, Options options) {
            this.queueProducer = queueProducer;
            this.queue = queue;
            this.worker = worker;
            this.options = options;
        }

        public void call(Subscriber<? super T> child) {
            QueueProducer<? super T> qp = new QueueProducer<T>(this.queue, child, this.worker, this.options.delayError());
            this.queueProducer.set(qp);
            child.setProducer(qp);
        }
    }
}

