/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.buffertofile;

import com.github.davidmoten.util.Preconditions;
import java.io.File;
import java.io.IOException;
import rx.functions.Func0;

public final class Options {
    public static final String DEFAULT_FILE_PREFIX = "bufferToFileDb";
    private final Func0<File> fileFactory;
    private final boolean delayError;
    private final long rolloverEvery;
    private final long rolloverSizeBytes;
    private final int bufferSizeBytes;

    private Options(Func0<File> filefactory, boolean delayError, long rolloverEvery, int bufferSizeBytes, long rolloverSizeBytes) {
        Preconditions.checkNotNull(filefactory);
        Preconditions.checkArgument(rolloverSizeBytes > 0L, "rolloverSizeBytes must be greater than zero");
        Preconditions.checkArgument(rolloverEvery > 1L, "rolloverEvery must be greater than one");
        Preconditions.checkArgument(bufferSizeBytes > 0, "bufferSizeBytes must be greater than 0");
        this.fileFactory = filefactory;
        this.delayError = delayError;
        this.rolloverEvery = rolloverEvery;
        this.rolloverSizeBytes = rolloverSizeBytes;
        this.bufferSizeBytes = bufferSizeBytes;
    }

    public Func0<File> fileFactory() {
        return this.fileFactory;
    }

    public boolean delayError() {
        return this.delayError;
    }

    public long rolloverEvery() {
        return this.rolloverEvery;
    }

    public long rolloverSizeBytes() {
        return this.rolloverSizeBytes;
    }

    public int bufferSizeBytes() {
        return this.bufferSizeBytes;
    }

    public boolean rolloverEnabled() {
        return this.rolloverSizeBytes != Long.MAX_VALUE || this.rolloverEvery != Long.MAX_VALUE;
    }

    private static Builder builder() {
        return new Builder();
    }

    public static Builder fileFactory(Func0<File> fileFactory) {
        return Options.builder().fileFactory(fileFactory);
    }

    public static Builder delayError(boolean delayError) {
        return Options.builder().delayError(delayError);
    }

    public static Builder rolloverEvery(long rolloverEvery) {
        return Options.builder().rolloverEvery(rolloverEvery);
    }

    public static Builder rolloverSizeBytes(long rolloverSizeBytes) {
        return Options.builder().rolloverSizeBytes(rolloverSizeBytes);
    }

    public static Builder rolloverSizeMB(double rolloverSizeMB) {
        return Options.builder().rolloverSizeMB(rolloverSizeMB);
    }

    public static Builder disableRollover() {
        return Options.builder().disableRollover();
    }

    public static Builder bufferSizeBytes(int bufferSizeBytes) {
        return Options.builder().bufferSizeBytes(bufferSizeBytes);
    }

    public static Options defaultInstance() {
        return Options.builder().build();
    }

    private static class FileFactoryHolder {
        private static final Func0<File> INSTANCE = new Func0<File>(){

            public File call() {
                try {
                    return File.createTempFile(Options.DEFAULT_FILE_PREFIX, "");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };

        private FileFactoryHolder() {
        }

        static /* synthetic */ Func0 access$100() {
            return INSTANCE;
        }
    }

    public static class Builder {
        private Func0<File> fileFactory = FileFactoryHolder.access$100();
        private boolean delayError = true;
        private long rolloverSizeBytes = Long.MAX_VALUE;
        private long rolloverEvery = 1000000L;
        private int bufferSizeBytes = 1024;

        private Builder() {
        }

        public Builder rolloverSizeMB(double rolloverSizeMB) {
            return this.rolloverSizeBytes(Math.round(rolloverSizeMB * 1024.0 * 1024.0));
        }

        public Builder rolloverSizeBytes(long rolloverSizeBytes) {
            this.rolloverSizeBytes = rolloverSizeBytes;
            return this;
        }

        public Builder disableRollover() {
            this.rolloverSizeBytes = Long.MAX_VALUE;
            return this.rolloverEvery(Long.MAX_VALUE);
        }

        public Builder bufferSizeBytes(int bufferSizeBytes) {
            this.bufferSizeBytes = bufferSizeBytes;
            return this;
        }

        public Builder rolloverEvery(long rolloverEvery) {
            this.rolloverEvery = rolloverEvery;
            return this;
        }

        public Builder fileFactory(Func0<File> fileFactory) {
            this.fileFactory = fileFactory;
            return this;
        }

        public Builder delayError(boolean delayError) {
            this.delayError = delayError;
            return this;
        }

        public Options build() {
            return new Options(this.fileFactory, this.delayError, this.rolloverEvery, this.bufferSizeBytes, this.rolloverSizeBytes);
        }
    }
}

