/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.component.instance;

import org.apache.hadoop.yarn.api.records.ContainerId;

public class ComponentInstanceId
implements Comparable<ComponentInstanceId> {
    private long Id;
    private String name;
    private ContainerId containerId;

    public ComponentInstanceId(long id, String name) {
        this.Id = id;
        this.name = name;
    }

    public long getId() {
        return this.Id;
    }

    public String getCompName() {
        return this.name;
    }

    public String getCompInstanceName() {
        return this.getCompName() + "-" + this.getId();
    }

    public void setContainerId(ContainerId containerId) {
        this.containerId = containerId;
    }

    public String toString() {
        if (this.containerId == null) {
            return "[COMPINSTANCE " + this.getCompInstanceName() + "]";
        }
        return "[COMPINSTANCE " + this.getCompInstanceName() + " : " + this.containerId + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComponentInstanceId that = (ComponentInstanceId)o;
        if (this.getId() != that.getId()) {
            return false;
        }
        return this.getCompName() != null ? this.getCompName().equals(that.getCompName()) : that.getCompName() == null;
    }

    public int hashCode() {
        int result = (int)(this.getId() ^ this.getId() >>> 32);
        result = 31 * result + (this.getCompName() != null ? this.getCompName().hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(ComponentInstanceId to) {
        int delta = this.getCompName().compareTo(to.getCompName());
        if (delta == 0) {
            return Long.compare(this.getId(), to.getId());
        }
        if (delta < 0) {
            return -1;
        }
        return 1;
    }
}

