/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.directconnectivity;

import com.microsoft.azure.cosmosdb.BridgeInternal;
import com.microsoft.azure.cosmosdb.DocumentClientException;
import com.microsoft.azure.cosmosdb.Error;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.HttpUtils;
import io.reactivex.netty.protocol.http.client.HttpResponseHeaders;
import java.util.Map;

public class PartitionKeyRangeGoneException
extends DocumentClientException {
    public PartitionKeyRangeGoneException() {
        this("The requested resource is no longer available at the server.");
    }

    public PartitionKeyRangeGoneException(Error error, long lsn, String partitionKeyRangeId, Map<String, String> responseHeaders) {
        super(410, error, responseHeaders);
        BridgeInternal.setLSN((DocumentClientException)this, (long)lsn);
        BridgeInternal.setPartitionKeyRangeId((DocumentClientException)this, (String)partitionKeyRangeId);
        this.setSubstatus();
    }

    public PartitionKeyRangeGoneException(String message) {
        this(message, null, null, null);
    }

    public PartitionKeyRangeGoneException(String message, Exception innerException) {
        this(message, innerException, (HttpResponseHeaders)null, null);
    }

    public PartitionKeyRangeGoneException(Exception innerException) {
        this("The requested resource is no longer available at the server.", innerException, (HttpResponseHeaders)null, null);
    }

    public PartitionKeyRangeGoneException(String message, HttpResponseHeaders headers, String requestUri) {
        super(message, null, HttpUtils.asMap((HttpResponseHeaders)headers), 410, requestUri);
        this.setSubstatus();
    }

    public PartitionKeyRangeGoneException(String message, Exception innerException, HttpResponseHeaders headers, String requestUri) {
        super(message, innerException, HttpUtils.asMap((HttpResponseHeaders)headers), 410, requestUri);
        this.setSubstatus();
    }

    private void setSubstatus() {
        this.getResponseHeaders().put("x-ms-substatus", Integer.toString(1002));
    }
}

