/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace;

import com.google.common.collect.ImmutableList;
import com.lancedb.lance.namespace.util.ValidationUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class ObjectIdentifier {
    private static final String DELIMITER_DEFAULT = ".";
    private final String[] levels;

    private ObjectIdentifier(String[] levels) {
        this.levels = levels;
    }

    public static ObjectIdentifier of(List<String> levels) {
        ValidationUtil.checkNotNull(levels, "Identifier must not be null", new Object[0]);
        levels.stream().forEach(level -> ValidationUtil.checkNotNullOrEmptyString(level, "Invalid namespace containing empty string levels %s", levels));
        return new ObjectIdentifier(levels.toArray(new String[0]));
    }

    public static ObjectIdentifier of(String id) {
        return ObjectIdentifier.of(id, DELIMITER_DEFAULT);
    }

    public static ObjectIdentifier of(String id, String delimiter) {
        ValidationUtil.checkNotNull(id, "Identifier must not be null", new Object[0]);
        ValidationUtil.checkNotNull(delimiter, "Identifier must not be null", new Object[0]);
        if (id.equals(delimiter)) {
            return new ObjectIdentifier(new String[0]);
        }
        return new ObjectIdentifier(id.split(delimiter));
    }

    public String levelAtListPos(int pos) {
        return this.levels[pos];
    }

    public String stringStyleId() {
        return this.stringStyleId(DELIMITER_DEFAULT);
    }

    public String stringStyleId(String delimiter) {
        if (this.levels.length == 0) {
            return delimiter;
        }
        return String.join((CharSequence)delimiter, this.levels);
    }

    public List<String> listStyleId() {
        return ImmutableList.copyOf((Object[])this.levels);
    }

    public List<String> parent() {
        ValidationUtil.checkArgument(this.levels.length > 0, "Root namespace does not have a parent", new Object[0]);
        if (this.levels.length == 1) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf((Object[])Arrays.copyOfRange(this.levels, 0, this.levels.length - 1));
    }

    public int levels() {
        return this.levels.length;
    }

    public boolean isRoot() {
        return this.levels.length == 0;
    }

    public String toString() {
        return "[root -> " + String.join((CharSequence)" -> ", this.levels) + "]";
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectIdentifier that = (ObjectIdentifier)o;
        return Objects.deepEquals(this.levels, that.levels);
    }

    public int hashCode() {
        return Arrays.hashCode(this.levels);
    }
}

