/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.job.local;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.arrow.util.Preconditions;
import org.apache.arrow.util.VisibleForTesting;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.job.JobTemplate;
import org.apache.gravitino.job.SparkJobTemplate;
import org.apache.gravitino.job.local.LocalProcessBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkProcessBuilder
extends LocalProcessBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(SparkProcessBuilder.class);
    private static final String ENV_SPARK_HOME = "SPARK_HOME";
    private final String sparkSubmit;

    protected SparkProcessBuilder(SparkJobTemplate sparkJobTemplate, Map<String, String> configs) {
        super((JobTemplate)sparkJobTemplate, configs);
        String sparkHome = Optional.ofNullable(configs.get("sparkHome")).orElse(System.getenv(ENV_SPARK_HOME));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)sparkHome), (Object)"gravitino.jobExecutor.local.sparkHome or SPARK_HOME environment variable must be set for Spark jobs");
        this.sparkSubmit = sparkHome + "/bin/spark-submit";
        File sparkSubmitFile = new File(this.sparkSubmit);
        Preconditions.checkArgument((boolean)sparkSubmitFile.canExecute(), (Object)("spark-submit is not found or not executable: " + this.sparkSubmit));
    }

    @VisibleForTesting
    static List<String> generateSparkSubmitCommand(String sparkSubmit, SparkJobTemplate sparkJobTemplate) {
        ArrayList commandList = Lists.newArrayList((Object[])new String[]{sparkSubmit});
        if (StringUtils.isNotBlank((CharSequence)sparkJobTemplate.className())) {
            commandList.add("--class");
            commandList.add(sparkJobTemplate.className());
        }
        if (!sparkJobTemplate.jars().isEmpty()) {
            commandList.add("--jars");
            commandList.add(String.join((CharSequence)",", sparkJobTemplate.jars()));
        }
        if (!sparkJobTemplate.files().isEmpty()) {
            commandList.add("--files");
            commandList.add(String.join((CharSequence)",", sparkJobTemplate.files()));
        }
        if (!sparkJobTemplate.archives().isEmpty()) {
            commandList.add("--archives");
            commandList.add(String.join((CharSequence)",", sparkJobTemplate.archives()));
        }
        for (Map.Entry entry : sparkJobTemplate.configs().entrySet()) {
            commandList.add("--conf");
            commandList.add((String)entry.getKey() + "=" + (String)entry.getValue());
        }
        commandList.add(sparkJobTemplate.executable());
        commandList.addAll(sparkJobTemplate.arguments());
        return commandList;
    }

    @Override
    public Process start() {
        SparkJobTemplate sparkJobTemplate = (SparkJobTemplate)this.jobTemplate;
        List<String> commandList = SparkProcessBuilder.generateSparkSubmitCommand(this.sparkSubmit, sparkJobTemplate);
        ProcessBuilder builder = new ProcessBuilder(commandList);
        builder.directory(this.workingDirectory);
        builder.environment().putAll(sparkJobTemplate.environments());
        File outputFile = new File(this.workingDirectory, "output.log");
        File errorFile = new File(this.workingDirectory, "error.log");
        builder.redirectOutput(outputFile);
        builder.redirectError(errorFile);
        LOG.info("Starting local Spark job with command: {}, environment variables: {}", (Object)Joiner.on((String)" ").join(commandList), (Object)Joiner.on((String)", ").withKeyValueSeparator(": ").join(sparkJobTemplate.environments()));
        try {
            return builder.start();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to start Spark process", e);
        }
    }
}

