/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.connector.authorization;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.connector.authorization.AuthorizationPlugin;
import org.apache.gravitino.connector.authorization.AuthorizationProvider;
import org.apache.gravitino.utils.IsolatedClassLoader;

public abstract class BaseAuthorization<T extends BaseAuthorization>
implements AuthorizationProvider,
Closeable {
    public abstract AuthorizationPlugin newPlugin(String var1, String var2, Map<String, String> var3);

    @Override
    public void close() throws IOException {
    }

    public static BaseAuthorization<?> createAuthorization(IsolatedClassLoader classLoader, String authorizationProvider) throws Exception {
        BaseAuthorization authorization = classLoader.withClassLoader(cl -> {
            try {
                ServiceLoader<AuthorizationProvider> loader = ServiceLoader.load(AuthorizationProvider.class, cl);
                List providers = Streams.stream(loader.iterator()).filter(p -> p.shortName().equalsIgnoreCase(authorizationProvider)).map(Object::getClass).collect(Collectors.toList());
                if (providers.isEmpty()) {
                    throw new IllegalArgumentException("No authorization provider found for: " + authorizationProvider);
                }
                if (providers.size() > 1) {
                    throw new IllegalArgumentException("Multiple authorization providers found for: " + authorizationProvider);
                }
                return (BaseAuthorization)((Class)Iterables.getOnlyElement(providers)).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        return authorization;
    }

    public static Optional<String> buildAuthorizationPkgPath(Map<String, String> conf) {
        String gravitinoHome = System.getenv("GRAVITINO_HOME");
        Preconditions.checkArgument((gravitinoHome != null ? 1 : 0) != 0, (Object)"GRAVITINO_HOME not set");
        boolean testEnv = System.getenv("GRAVITINO_TEST") != null;
        String authorizationProvider = conf.get("authorization-provider");
        if (StringUtils.isBlank((CharSequence)authorizationProvider)) {
            return Optional.empty();
        }
        String pkgPath = testEnv ? String.join((CharSequence)File.separator, gravitinoHome, "authorizations", "authorization-" + authorizationProvider, "build", "libs") : String.join((CharSequence)File.separator, gravitinoHome, "authorizations", authorizationProvider, "libs");
        return Optional.of(pkgPath);
    }
}

