/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import java.util.List;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.avro.ValueReader;
import org.apache.iceberg.avro.ValueReaders;
import org.apache.iceberg.common.DynConstructors;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.Pair;

class InternalReaders {
    private InternalReaders() {
    }

    static ValueReader<? extends Record> struct(Types.StructType struct, List<Pair<Integer, ValueReader<?>>> readPlan) {
        return new RecordReader(readPlan, struct);
    }

    static <S extends StructLike> ValueReader<S> struct(Types.StructType struct, Class<S> structClass, List<Pair<Integer, ValueReader<?>>> readPlan) {
        return new PlannedStructLikeReader<S>(readPlan, struct, structClass);
    }

    private static class RecordReader
    extends ValueReaders.PlannedStructReader<GenericRecord> {
        private final Types.StructType structType;

        private RecordReader(List<Pair<Integer, ValueReader<?>>> readPlan, Types.StructType structType) {
            super(readPlan);
            this.structType = structType;
        }

        @Override
        protected GenericRecord reuseOrCreate(Object reuse) {
            if (reuse instanceof GenericRecord) {
                return (GenericRecord)reuse;
            }
            return GenericRecord.create(this.structType);
        }

        @Override
        protected Object get(GenericRecord struct, int pos) {
            return struct.get(pos);
        }

        @Override
        protected void set(GenericRecord struct, int pos, Object value) {
            struct.set(pos, value);
        }
    }

    private static class PlannedStructLikeReader<S extends StructLike>
    extends ValueReaders.PlannedStructReader<S> {
        private final Types.StructType structType;
        private final Class<S> structClass;
        private final DynConstructors.Ctor<S> ctor;

        private PlannedStructLikeReader(List<Pair<Integer, ValueReader<?>>> readPlan, Types.StructType structType, Class<S> structClass) {
            super(readPlan);
            this.structType = structType;
            this.structClass = structClass;
            this.ctor = DynConstructors.builder(StructLike.class).hiddenImpl(structClass, new Class[]{Types.StructType.class}).hiddenImpl(structClass, new Class[0]).build();
        }

        @Override
        protected S reuseOrCreate(Object reuse) {
            if (this.structClass.isInstance(reuse)) {
                return (S)((StructLike)this.structClass.cast(reuse));
            }
            return (S)((StructLike)this.ctor.newInstance(new Object[]{this.structType}));
        }

        @Override
        protected Object get(S struct, int pos) {
            return struct.get(pos, Object.class);
        }

        @Override
        protected void set(S struct, int pos, Object value) {
            struct.set(pos, value);
        }
    }
}

