/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.iceberg.service.authorization;

import com.google.common.base.Preconditions;
import org.apache.gravitino.iceberg.service.provider.IcebergConfigProvider;

public class IcebergRESTServerContext {
    private boolean isAuthorizationEnabled;
    private String metalakeName;
    private String defaultCatalogName;

    private IcebergRESTServerContext(Boolean isAuthorizationEnabled, String metalakeName, String defaultCatalogName) {
        this.isAuthorizationEnabled = isAuthorizationEnabled;
        this.metalakeName = metalakeName;
        this.defaultCatalogName = defaultCatalogName;
    }

    public static IcebergRESTServerContext create(IcebergConfigProvider configProvider, Boolean enableAuth) {
        InstanceHolder.INSTANCE = new IcebergRESTServerContext(enableAuth, configProvider.getMetalakeName(), configProvider.getDefaultCatalogName());
        return InstanceHolder.INSTANCE;
    }

    public static IcebergRESTServerContext getInstance() {
        Preconditions.checkState((InstanceHolder.INSTANCE != null ? 1 : 0) != 0, (Object)"Not initialized");
        return InstanceHolder.INSTANCE;
    }

    public boolean isAuthorizationEnabled() {
        return this.isAuthorizationEnabled;
    }

    public String metalakeName() {
        return this.metalakeName;
    }

    public String defaultCatalogName() {
        return this.defaultCatalogName;
    }

    private static class InstanceHolder {
        private static IcebergRESTServerContext INSTANCE;

        private InstanceHolder() {
        }
    }
}

