/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.trino.connector.catalog;

import com.google.common.base.Strings;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.SchemaTableName;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.gravitino.Catalog;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.Schema;
import org.apache.gravitino.SupportsSchemas;
import org.apache.gravitino.client.GravitinoMetalake;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NoSuchTableException;
import org.apache.gravitino.exceptions.NonEmptySchemaException;
import org.apache.gravitino.exceptions.TableAlreadyExistsException;
import org.apache.gravitino.rel.Table;
import org.apache.gravitino.rel.TableCatalog;
import org.apache.gravitino.rel.TableChange;
import org.apache.gravitino.rel.types.Type;
import org.apache.gravitino.trino.connector.GravitinoErrorCode;
import org.apache.gravitino.trino.connector.metadata.GravitinoColumn;
import org.apache.gravitino.trino.connector.metadata.GravitinoSchema;
import org.apache.gravitino.trino.connector.metadata.GravitinoTable;

public class CatalogConnectorMetadata {
    private static final String CATALOG_DOES_NOT_EXIST_MSG = "Catalog does not exist";
    private static final String SCHEMA_DOES_NOT_EXIST_MSG = "Schema does not exist";
    private final String catalogName;
    private final SupportsSchemas schemaCatalog;
    private final TableCatalog tableCatalog;

    public CatalogConnectorMetadata(GravitinoMetalake metalake, NameIdentifier catalogIdentifier) {
        try {
            this.catalogName = catalogIdentifier.name();
            Catalog catalog = metalake.loadCatalog(this.catalogName);
            this.schemaCatalog = catalog.asSchemas();
            this.tableCatalog = catalog.asTableCatalog();
        }
        catch (NoSuchCatalogException e) {
            throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_CATALOG_NOT_EXISTS, CATALOG_DOES_NOT_EXIST_MSG, (Throwable)e);
        }
        catch (UnsupportedOperationException e) {
            throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_UNSUPPORTED_OPERATION, "Catalog does not support schema or table operations." + e.getMessage(), (Throwable)e);
        }
    }

    public List<String> listSchemaNames() {
        try {
            return Arrays.asList(this.schemaCatalog.listSchemas());
        }
        catch (NoSuchCatalogException e) {
            throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_CATALOG_NOT_EXISTS, CATALOG_DOES_NOT_EXIST_MSG, (Throwable)e);
        }
    }

    public GravitinoSchema getSchema(String schemaName) {
        try {
            Schema schema = this.schemaCatalog.loadSchema(schemaName);
            return new GravitinoSchema(schema);
        }
        catch (NoSuchSchemaException e) {
            throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_SCHEMA_NOT_EXISTS, SCHEMA_DOES_NOT_EXIST_MSG, (Throwable)e);
        }
    }

    public GravitinoTable getTable(String schemaName, String tableName) {
        try {
            Table table = this.tableCatalog.loadTable(NameIdentifier.of((String[])new String[]{schemaName, tableName}));
            return new GravitinoTable(schemaName, tableName, table);
        }
        catch (NoSuchTableException e) {
            throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_TABLE_NOT_EXISTS, "Table does not exist", (Throwable)e);
        }
    }

    public List<String> listTables(String schemaName) {
        try {
            NameIdentifier[] tables = this.tableCatalog.listTables(Namespace.of((String[])new String[]{schemaName}));
            return Arrays.stream(tables).map(NameIdentifier::name).toList();
        }
        catch (NoSuchSchemaException e) {
            throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_SCHEMA_NOT_EXISTS, SCHEMA_DOES_NOT_EXIST_MSG, (Throwable)e);
        }
    }

    public boolean tableExists(String schemaName, String tableName) {
        return this.tableCatalog.tableExists(NameIdentifier.of((String[])new String[]{schemaName, tableName}));
    }

    public void createTable(GravitinoTable table, boolean ignoreExisting) {
        block3: {
            NameIdentifier identifier = NameIdentifier.of((String[])new String[]{table.getSchemaName(), table.getName()});
            try {
                this.tableCatalog.createTable(identifier, table.getRawColumns(), table.getComment(), table.getProperties(), table.getPartitioning(), table.getDistribution(), table.getSortOrders(), table.getIndexes());
            }
            catch (NoSuchSchemaException e) {
                throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_SCHEMA_NOT_EXISTS, SCHEMA_DOES_NOT_EXIST_MSG, (Throwable)e);
            }
            catch (TableAlreadyExistsException e) {
                if (ignoreExisting) break block3;
                throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_TABLE_ALREADY_EXISTS, "Table already exists", (Throwable)e);
            }
        }
    }

    public void createSchema(GravitinoSchema schema) {
        try {
            this.schemaCatalog.createSchema(schema.getName(), schema.getComment(), schema.getProperties());
        }
        catch (NoSuchSchemaException e) {
            throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_CATALOG_NOT_EXISTS, CATALOG_DOES_NOT_EXIST_MSG, (Throwable)e);
        }
        catch (TableAlreadyExistsException e) {
            throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_SCHEMA_ALREADY_EXISTS, "Schema already exists", (Throwable)e);
        }
    }

    public void dropSchema(String schemaName, boolean cascade) {
        try {
            boolean success = this.schemaCatalog.dropSchema(schemaName, cascade);
            if (!success) {
                throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_SCHEMA_NOT_EXISTS, "Drop schema failed");
            }
        }
        catch (NonEmptySchemaException e) {
            throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_SCHEMA_NOT_EMPTY, "Schema does not empty", (Throwable)e);
        }
    }

    public void dropTable(SchemaTableName tableName) {
        boolean dropped = this.tableCatalog.dropTable(NameIdentifier.of((String[])new String[]{tableName.getSchemaName(), tableName.getTableName()}));
        if (!dropped) {
            throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_OPERATION_FAILED, "Failed to drop table " + String.valueOf(tableName));
        }
    }

    public void renameSchema(String source, String target) {
        throw new NotImplementedException();
    }

    private void applyAlter(SchemaTableName tableName, TableChange ... change) {
        try {
            this.tableCatalog.alterTable(NameIdentifier.of((String[])new String[]{tableName.getSchemaName(), tableName.getTableName()}), change);
        }
        catch (NoSuchTableException e) {
            throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_TABLE_NOT_EXISTS, "Table does not exist");
        }
        catch (IllegalArgumentException e) {
            String message = GravitinoErrorCode.toSimpleErrorMessage(e);
            throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_ILLEGAL_ARGUMENT, message, (Throwable)e);
        }
    }

    public void renameTable(SchemaTableName oldTableName, SchemaTableName newTableName) {
        if (!oldTableName.getSchemaName().equals(newTableName.getSchemaName())) {
            throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_UNSUPPORTED_OPERATION, "Cannot rename table across schemas");
        }
        if (oldTableName.getTableName().equals(newTableName.getTableName())) {
            return;
        }
        this.applyAlter(oldTableName, TableChange.rename((String)newTableName.getTableName()));
    }

    public void setTableComment(SchemaTableName schemaTableName, String comment) {
        this.applyAlter(schemaTableName, TableChange.updateComment((String)comment));
    }

    public void setTableProperties(SchemaTableName schemaTableName, Map<String, String> properties) {
        Map<String, String> oldProperties = this.getTable(schemaTableName.getSchemaName(), schemaTableName.getTableName()).getProperties();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            if (entry.getValue().equals(oldProperties.get(entry.getKey()))) continue;
            this.applyAlter(schemaTableName, TableChange.setProperty((String)entry.getKey(), (String)entry.getValue()));
        }
    }

    public void addColumn(SchemaTableName schemaTableName, GravitinoColumn column) {
        String[] columnNames = new String[]{column.getName()};
        if (Strings.isNullOrEmpty((String)column.getComment())) {
            this.applyAlter(schemaTableName, TableChange.addColumn((String[])columnNames, (Type)column.getType(), (boolean)column.isNullable()));
        } else {
            this.applyAlter(schemaTableName, TableChange.addColumn((String[])columnNames, (Type)column.getType(), (String)column.getComment(), (boolean)column.isNullable()));
        }
    }

    public void dropColumn(SchemaTableName schemaTableName, String columnName) {
        String[] columnNames = new String[]{columnName};
        this.applyAlter(schemaTableName, TableChange.deleteColumn((String[])columnNames, (Boolean)true));
    }

    public void setColumnComment(SchemaTableName schemaTableName, String columnName, String comment) {
        String[] columnNames = new String[]{columnName};
        this.applyAlter(schemaTableName, TableChange.updateColumnComment((String[])columnNames, (String)comment));
    }

    public void renameColumn(SchemaTableName schemaTableName, String columnName, String target) {
        if (columnName.equals(target)) {
            return;
        }
        String[] columnNames = new String[]{columnName};
        this.applyAlter(schemaTableName, TableChange.renameColumn((String[])columnNames, (String)target));
    }

    public void setColumnType(SchemaTableName schemaTableName, String columnName, Type type) {
        String[] columnNames = new String[]{columnName};
        this.applyAlter(schemaTableName, TableChange.updateColumnType((String[])columnNames, (Type)type));
    }
}

