/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.requests;

import javax.annotation.Nullable;
import org.apache.gravitino.dto.policy.PolicyContentDTO;
import org.apache.gravitino.rest.RESTRequest;
import org.apache.gravitino.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.gravitino.shaded.com.fasterxml.jackson.annotation.JsonSubTypes;
import org.apache.gravitino.shaded.com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.apache.gravitino.shaded.com.google.common.base.Preconditions;
import org.apache.gravitino.shaded.org.apache.commons.lang3.StringUtils;

public class PolicyCreateRequest
implements RESTRequest {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="comment")
    @Nullable
    private final String comment;
    @JsonProperty(value="policyType")
    private final String policyType;
    @JsonProperty(value="enabled", defaultValue="true")
    private final Boolean enabled;
    @JsonProperty(value="content")
    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXTERNAL_PROPERTY, property="policyType", defaultImpl=PolicyContentDTO.CustomContentDTO.class)
    @JsonSubTypes(value={})
    private final PolicyContentDTO policyContent;

    public PolicyCreateRequest(String name, String type, String comment, boolean enabled, PolicyContentDTO content) {
        this.name = name;
        this.policyType = type;
        this.comment = comment;
        this.enabled = enabled;
        this.policyContent = content;
    }

    private PolicyCreateRequest() {
        this(null, null, null, true, null);
    }

    @Override
    public void validate() throws IllegalArgumentException {
        Preconditions.checkArgument(StringUtils.isNotBlank(this.name), "\"name\" is required and cannot be empty");
        Preconditions.checkArgument(StringUtils.isNotBlank(this.policyType), "\"policyType\" is required and cannot be empty");
        Preconditions.checkArgument(this.policyContent != null, "\"content\" is required and cannot be null");
        this.policyContent.validate();
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getComment() {
        return this.comment;
    }

    public String getPolicyType() {
        return this.policyType;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public PolicyContentDTO getPolicyContent() {
        return this.policyContent;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PolicyCreateRequest)) {
            return false;
        }
        PolicyCreateRequest other = (PolicyCreateRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        String this$policyType = this.getPolicyType();
        String other$policyType = other.getPolicyType();
        if (this$policyType == null ? other$policyType != null : !this$policyType.equals(other$policyType)) {
            return false;
        }
        PolicyContentDTO this$policyContent = this.getPolicyContent();
        PolicyContentDTO other$policyContent = other.getPolicyContent();
        return !(this$policyContent == null ? other$policyContent != null : !this$policyContent.equals(other$policyContent));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PolicyCreateRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        String $policyType = this.getPolicyType();
        result = result * 59 + ($policyType == null ? 43 : $policyType.hashCode());
        PolicyContentDTO $policyContent = this.getPolicyContent();
        result = result * 59 + ($policyContent == null ? 43 : $policyContent.hashCode());
        return result;
    }

    public String toString() {
        return "PolicyCreateRequest(name=" + this.getName() + ", comment=" + this.getComment() + ", policyType=" + this.getPolicyType() + ", enabled=" + this.getEnabled() + ", policyContent=" + String.valueOf(this.getPolicyContent()) + ")";
    }
}

