/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.rel;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.gravitino.dto.rel.ColumnDTO;
import org.apache.gravitino.shaded.com.google.common.base.Preconditions;
import org.apache.gravitino.shaded.org.apache.commons.lang3.ArrayUtils;

public class PartitionUtils {
    public static void validateFieldExistence(ColumnDTO[] columns, String[] fieldName) throws IllegalArgumentException {
        Preconditions.checkArgument(ArrayUtils.isNotEmpty(columns), "columns cannot be null or empty");
        Preconditions.checkArgument(ArrayUtils.isNotEmpty(fieldName), "fieldName cannot be null or empty");
        Preconditions.checkArgument(fieldName.length == 1, "Nested fields are not supported yet. Field name array must contain exactly one element, but got: %s", (Object)Arrays.toString(fieldName));
        List partitionColumn = Arrays.stream(columns).filter(c -> c.name().equalsIgnoreCase(fieldName[0])).collect(Collectors.toList());
        Preconditions.checkArgument(partitionColumn.size() == 1, "Field '%s' not found in table", (Object)fieldName[0]);
    }

    private PartitionUtils() {
    }
}

