/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.rel;

import org.apache.gravitino.dto.rel.expressions.LiteralDTO;
import org.apache.gravitino.json.JsonUtils;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.expressions.Expression;
import org.apache.gravitino.rel.types.Type;
import org.apache.gravitino.rel.types.Types;
import org.apache.gravitino.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.gravitino.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.gravitino.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.gravitino.shaded.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.gravitino.shaded.com.google.common.base.Preconditions;

public class ColumnDTO
implements Column {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="type")
    @JsonSerialize(using=JsonUtils.TypeSerializer.class)
    @JsonDeserialize(using=JsonUtils.TypeDeserializer.class)
    private Type dataType;
    @JsonProperty(value="comment")
    private String comment;
    @JsonProperty(value="nullable")
    private boolean nullable = true;
    @JsonProperty(value="autoIncrement")
    private boolean autoIncrement = false;
    @JsonProperty(value="defaultValue")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonSerialize(using=JsonUtils.ColumnDefaultValueSerializer.class)
    @JsonDeserialize(using=JsonUtils.ColumnDefaultValueDeserializer.class)
    private Expression defaultValue = Column.DEFAULT_VALUE_NOT_SET;

    private ColumnDTO() {
    }

    private ColumnDTO(String name, Type dataType, String comment, boolean nullable, boolean autoIncrement, Expression defaultValue) {
        this.name = name;
        this.dataType = dataType;
        this.comment = comment;
        this.nullable = nullable;
        this.autoIncrement = autoIncrement;
        this.defaultValue = defaultValue == null ? Column.DEFAULT_VALUE_NOT_SET : defaultValue;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Type dataType() {
        return this.dataType;
    }

    @Override
    public String comment() {
        return this.comment;
    }

    @Override
    public boolean nullable() {
        return this.nullable;
    }

    @Override
    public boolean autoIncrement() {
        return this.autoIncrement;
    }

    @Override
    public Expression defaultValue() {
        return this.defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void validate() throws IllegalArgumentException {
        if (this.name() == null || this.name().isEmpty()) {
            throw new IllegalArgumentException("Column name cannot be null or empty.");
        }
        if (this.dataType() == null) {
            throw new IllegalArgumentException("Column data type cannot be null.");
        }
        if (!this.nullable() && this.defaultValue() instanceof LiteralDTO && ((LiteralDTO)this.defaultValue()).dataType().equals(Types.NullType.get())) {
            throw new IllegalArgumentException("Column cannot be non-nullable with a null default value: " + this.name());
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ColumnDTO)) {
            return false;
        }
        ColumnDTO other = (ColumnDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.nullable != other.nullable) {
            return false;
        }
        if (this.autoIncrement != other.autoIncrement) {
            return false;
        }
        String this$name = this.name;
        String other$name = other.name;
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Type this$dataType = this.dataType;
        Type other$dataType = other.dataType;
        if (this$dataType == null ? other$dataType != null : !this$dataType.equals(other$dataType)) {
            return false;
        }
        String this$comment = this.comment;
        String other$comment = other.comment;
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        Expression this$defaultValue = this.defaultValue;
        Expression other$defaultValue = other.defaultValue;
        return !(this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ColumnDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.nullable ? 79 : 97);
        result = result * 59 + (this.autoIncrement ? 79 : 97);
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Type $dataType = this.dataType;
        result = result * 59 + ($dataType == null ? 43 : $dataType.hashCode());
        String $comment = this.comment;
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        Expression $defaultValue = this.defaultValue;
        result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
        return result;
    }

    public String toString() {
        return "ColumnDTO(name=" + this.name + ", dataType=" + String.valueOf(this.dataType) + ", comment=" + this.comment + ", nullable=" + this.nullable + ", autoIncrement=" + this.autoIncrement + ", defaultValue=" + String.valueOf(this.defaultValue) + ")";
    }

    public static class Builder<S extends Builder> {
        protected String name;
        protected Type dataType;
        protected String comment;
        protected boolean nullable = true;
        protected boolean autoIncrement = false;
        protected Expression defaultValue;

        public S withName(String name) {
            this.name = name;
            return (S)this;
        }

        public S withDataType(Type dataType) {
            this.dataType = dataType;
            return (S)this;
        }

        public S withComment(String comment) {
            this.comment = comment;
            return (S)this;
        }

        public S withNullable(boolean nullable) {
            this.nullable = nullable;
            return (S)this;
        }

        public S withAutoIncrement(boolean autoIncrement) {
            this.autoIncrement = autoIncrement;
            return (S)this;
        }

        public S withDefaultValue(Expression defaultValue) {
            this.defaultValue = defaultValue;
            return (S)this;
        }

        public ColumnDTO build() {
            Preconditions.checkNotNull(this.name, "Column name cannot be null");
            Preconditions.checkNotNull(this.dataType, "Column data type cannot be null");
            return new ColumnDTO(this.name, this.dataType, this.comment, this.nullable, this.autoIncrement, this.defaultValue);
        }
    }
}

