/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.ContextCustomizer;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.ErrorCauseExtractor;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.LocalRootSpan;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.OperationListener;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.SpanLinksBuilderImpl;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.SpanLinksExtractor;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.SpanStatusBuilderImpl;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.SpanStatusExtractor;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.SpanSuppressor;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.UnsafeAttributes;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.internal.InstrumenterAccess;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.internal.InstrumenterUtil;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.internal.SupportabilityMetrics;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class Instrumenter<REQUEST, RESPONSE> {
    private static final SupportabilityMetrics supportability = SupportabilityMetrics.instance();
    private final String instrumentationName;
    private final Tracer tracer;
    private final SpanNameExtractor<? super REQUEST> spanNameExtractor;
    private final SpanKindExtractor<? super REQUEST> spanKindExtractor;
    private final SpanStatusExtractor<? super REQUEST, ? super RESPONSE> spanStatusExtractor;
    private final List<? extends SpanLinksExtractor<? super REQUEST>> spanLinksExtractors;
    private final List<? extends AttributesExtractor<? super REQUEST, ? super RESPONSE>> attributesExtractors;
    private final List<? extends ContextCustomizer<? super REQUEST>> contextCustomizers;
    private final List<? extends OperationListener> operationListeners;
    private final ErrorCauseExtractor errorCauseExtractor;
    private final boolean enabled;
    private final SpanSuppressor spanSuppressor;

    public static <REQUEST, RESPONSE> InstrumenterBuilder<REQUEST, RESPONSE> builder(OpenTelemetry openTelemetry, String instrumentationName, SpanNameExtractor<? super REQUEST> spanNameExtractor) {
        return new InstrumenterBuilder(openTelemetry, instrumentationName, spanNameExtractor);
    }

    Instrumenter(InstrumenterBuilder<REQUEST, RESPONSE> builder) {
        this.instrumentationName = builder.instrumentationName;
        this.tracer = builder.buildTracer();
        this.spanNameExtractor = builder.spanNameExtractor;
        this.spanKindExtractor = builder.spanKindExtractor;
        this.spanStatusExtractor = builder.spanStatusExtractor;
        this.spanLinksExtractors = new ArrayList(builder.spanLinksExtractors);
        this.attributesExtractors = new ArrayList(builder.attributesExtractors);
        this.contextCustomizers = new ArrayList(builder.contextCustomizers);
        this.operationListeners = builder.buildOperationListeners();
        this.errorCauseExtractor = builder.errorCauseExtractor;
        this.enabled = builder.enabled;
        this.spanSuppressor = builder.buildSpanSuppressor();
    }

    public boolean shouldStart(Context parentContext, REQUEST request) {
        if (!this.enabled) {
            return false;
        }
        SpanKind spanKind = this.spanKindExtractor.extract(request);
        boolean suppressed = this.spanSuppressor.shouldSuppress(parentContext, spanKind);
        if (suppressed) {
            supportability.recordSuppressedSpan(spanKind, this.instrumentationName);
        }
        return !suppressed;
    }

    public Context start(Context parentContext, REQUEST request) {
        return this.doStart(parentContext, request, null);
    }

    public void end(Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        this.doEnd(context, request, response, error, null);
    }

    Context startAndEnd(Context parentContext, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error, Instant startTime, Instant endTime) {
        Context context = this.doStart(parentContext, request, startTime);
        this.doEnd(context, request, response, error, endTime);
        return context;
    }

    /*
     * WARNING - void declaration
     */
    private Context doStart(Context parentContext, REQUEST request, @Nullable Instant startTime) {
        void var8_17;
        void var8_14;
        void var8_11;
        SpanKind spanKind = this.spanKindExtractor.extract(request);
        SpanBuilder spanBuilder = this.tracer.spanBuilder(this.spanNameExtractor.extract(request)).setSpanKind(spanKind);
        if (startTime != null) {
            spanBuilder.setStartTimestamp(startTime);
        }
        SpanLinksBuilderImpl spanLinksBuilder = new SpanLinksBuilderImpl(spanBuilder);
        for (SpanLinksExtractor<REQUEST> spanLinksExtractor : this.spanLinksExtractors) {
            spanLinksExtractor.extract(spanLinksBuilder, parentContext, request);
        }
        UnsafeAttributes attributes = new UnsafeAttributes();
        for (AttributesExtractor<REQUEST, RESPONSE> attributesExtractor : this.attributesExtractors) {
            attributesExtractor.onStart(attributes, parentContext, request);
        }
        Context context = parentContext;
        for (ContextCustomizer<REQUEST> contextCustomizer : this.contextCustomizers) {
            Context context2 = contextCustomizer.onStart((Context)var8_11, request, attributes);
        }
        boolean bl = LocalRootSpan.isLocalRoot((Context)var8_11);
        spanBuilder.setAllAttributes((Attributes)attributes);
        Span span = spanBuilder.setParent((Context)var8_11).startSpan();
        Context context3 = var8_11.with((ImplicitContextKeyed)span);
        if (!this.operationListeners.isEmpty()) {
            long startNanos = Instrumenter.getNanos(startTime);
            for (OperationListener operationListener : this.operationListeners) {
                Context context4 = operationListener.onStart((Context)var8_14, attributes, startNanos);
            }
        }
        if (bl) {
            Context context5 = LocalRootSpan.store((Context)var8_14, span);
        }
        return this.spanSuppressor.storeInContext((Context)var8_17, spanKind, span);
    }

    private void doEnd(Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error, @Nullable Instant endTime) {
        Span span = Span.fromContext((Context)context);
        if (error != null) {
            error = this.errorCauseExtractor.extract(error);
            span.recordException(error);
        }
        UnsafeAttributes attributes = new UnsafeAttributes();
        for (AttributesExtractor<REQUEST, RESPONSE> extractor : this.attributesExtractors) {
            extractor.onEnd(attributes, context, request, response, error);
        }
        span.setAllAttributes((Attributes)attributes);
        if (!this.operationListeners.isEmpty()) {
            long endNanos = Instrumenter.getNanos(endTime);
            ListIterator<? extends OperationListener> i = this.operationListeners.listIterator(this.operationListeners.size());
            while (i.hasPrevious()) {
                i.previous().onEnd(context, attributes, endNanos);
            }
        }
        SpanStatusBuilderImpl spanStatusBuilder = new SpanStatusBuilderImpl(span);
        this.spanStatusExtractor.extract(spanStatusBuilder, request, response, error);
        if (endTime != null) {
            span.end(endTime);
        } else {
            span.end();
        }
    }

    private static long getNanos(@Nullable Instant time) {
        if (time == null) {
            return System.nanoTime();
        }
        return TimeUnit.SECONDS.toNanos(time.getEpochSecond()) + (long)time.getNano();
    }

    static {
        InstrumenterUtil.setInstrumenterAccess(new InstrumenterAccess(){

            public <RQ, RS> Context startAndEnd(Instrumenter<RQ, RS> instrumenter, Context parentContext, RQ request, @Nullable RS response, @Nullable Throwable error, Instant startTime, Instant endTime) {
                return instrumenter.startAndEnd(parentContext, request, response, error, startTime, endTime);
            }
        });
    }
}

