/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.dev.failsafe;

import io.trino.jdbc.$internal.dev.failsafe.PolicyBuilder;
import io.trino.jdbc.$internal.dev.failsafe.RateLimiter;
import io.trino.jdbc.$internal.dev.failsafe.RateLimiterConfig;
import io.trino.jdbc.$internal.dev.failsafe.internal.RateLimiterImpl;
import io.trino.jdbc.$internal.dev.failsafe.internal.util.Assert;
import java.time.Duration;

public class RateLimiterBuilder<R>
extends PolicyBuilder<RateLimiterBuilder<R>, RateLimiterConfig<R>, R> {
    RateLimiterBuilder(Duration executionRate) {
        super(new RateLimiterConfig(executionRate));
        ((RateLimiterConfig)this.config).maxWaitTime = Duration.ZERO;
    }

    RateLimiterBuilder(long maxPermits, Duration period) {
        super(new RateLimiterConfig(maxPermits, period));
        ((RateLimiterConfig)this.config).maxWaitTime = Duration.ZERO;
    }

    RateLimiterBuilder(RateLimiterConfig<R> config) {
        super(new RateLimiterConfig<R>(config));
    }

    public RateLimiter<R> build() {
        return new RateLimiterImpl(new RateLimiterConfig((RateLimiterConfig)this.config));
    }

    public RateLimiterBuilder<R> withMaxWaitTime(Duration maxWaitTime) {
        ((RateLimiterConfig)this.config).maxWaitTime = Assert.notNull(maxWaitTime, "maxWaitTime");
        return this;
    }
}

