/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.transforms;

import java.io.ObjectStreamException;
import java.time.temporal.ChronoUnit;
import org.apache.iceberg.transforms.Dates;
import org.apache.iceberg.transforms.SerializationProxies;
import org.apache.iceberg.transforms.TimeTransform;
import org.apache.iceberg.transforms.Timestamps;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.transforms.TransformUtil;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class Days<T>
extends TimeTransform<T> {
    private static final Days<?> INSTANCE = new Days();

    static <T> Days<T> get() {
        return INSTANCE;
    }

    @Override
    protected ChronoUnit granularity() {
        return ChronoUnit.DAYS;
    }

    @Override
    protected Transform<T, Integer> toEnum(Type type) {
        return Days.fromSourceType(type, Dates.DAY, Timestamps.MICROS_TO_DAY, Timestamps.NANOS_TO_DAY);
    }

    @Override
    public Type getResultType(Type sourceType) {
        return Types.DateType.get();
    }

    @Override
    public String toHumanString(Type alwaysDate, Integer value) {
        return value != null ? TransformUtil.humanDay(value) : "null";
    }

    public String toString() {
        return "day";
    }

    Object writeReplace() throws ObjectStreamException {
        return SerializationProxies.DaysTransformProxy.get();
    }
}

