/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.keytab;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.kerby.kerberos.kerb.keytab.KeytabInputStream;
import org.apache.kerby.kerberos.kerb.keytab.KeytabOutputStream;
import org.apache.kerby.kerberos.kerb.type.KerberosTime;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import org.apache.kerby.kerberos.kerb.type.base.PrincipalName;

public class KeytabEntry {
    private PrincipalName principal;
    private KerberosTime timestamp;
    private int kvno;
    private EncryptionKey key;

    public KeytabEntry(PrincipalName principal, KerberosTime timestamp, int kvno, EncryptionKey key) {
        this.principal = principal;
        this.timestamp = timestamp;
        this.kvno = kvno;
        this.key = key;
    }

    public KeytabEntry() {
    }

    void load(KeytabInputStream kis, int version, int entrySize) throws IOException {
        int bytesLeft = kis.available();
        this.principal = kis.readPrincipal(version);
        this.timestamp = kis.readTime();
        this.kvno = kis.readByte();
        this.key = kis.readKey();
        int entryBytesRead = bytesLeft - kis.available();
        if (entryBytesRead + 4 <= entrySize) {
            int tmp = kis.readInt();
            if (tmp != 0) {
                this.kvno = tmp;
            }
        } else if (entryBytesRead != entrySize) {
            throw new IOException(String.format("Bad input stream with less data read [%d] than expected [%d] for keytab entry.", entryBytesRead, entrySize));
        }
    }

    void store(KeytabOutputStream kos) throws IOException {
        byte[] body = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        KeytabOutputStream subKos = new KeytabOutputStream(baos);
        this.writeBody(subKos, 0);
        subKos.flush();
        body = baos.toByteArray();
        kos.writeInt(body.length);
        kos.write(body);
    }

    public EncryptionKey getKey() {
        return this.key;
    }

    public int getKvno() {
        return this.kvno;
    }

    public PrincipalName getPrincipal() {
        return this.principal;
    }

    public KerberosTime getTimestamp() {
        return this.timestamp;
    }

    void writeBody(KeytabOutputStream kos, int version) throws IOException {
        kos.writePrincipal(this.principal, version);
        kos.writeTime(this.timestamp);
        kos.writeByte(this.kvno);
        kos.writeKey(this.key, version);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeytabEntry that = (KeytabEntry)o;
        if (this.kvno != that.kvno) {
            return false;
        }
        if (!this.key.equals((Object)that.key)) {
            return false;
        }
        if (!this.principal.equals((Object)that.principal)) {
            return false;
        }
        return this.timestamp.equals((Object)that.timestamp);
    }

    public int hashCode() {
        int result = this.principal.hashCode();
        result = 31 * result + this.timestamp.hashCode();
        result = 31 * result + this.kvno;
        result = 31 * result + this.key.hashCode();
        return result;
    }
}

