/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.view;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.iceberg.MetadataUpdate;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.io.PositionOutputStream;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.util.JsonUtil;
import org.apache.iceberg.view.ImmutableViewMetadata;
import org.apache.iceberg.view.ViewHistoryEntry;
import org.apache.iceberg.view.ViewHistoryEntryParser;
import org.apache.iceberg.view.ViewMetadata;
import org.apache.iceberg.view.ViewVersion;
import org.apache.iceberg.view.ViewVersionParser;

public class ViewMetadataParser {
    static final String VIEW_UUID = "view-uuid";
    static final String FORMAT_VERSION = "format-version";
    static final String LOCATION = "location";
    static final String CURRENT_VERSION_ID = "current-version-id";
    static final String VERSIONS = "versions";
    static final String VERSION_LOG = "version-log";
    static final String PROPERTIES = "properties";
    static final String SCHEMAS = "schemas";

    private ViewMetadataParser() {
    }

    public static String toJson(ViewMetadata metadata) {
        return ViewMetadataParser.toJson(metadata, false);
    }

    public static String toJson(ViewMetadata metadata, boolean pretty) {
        return JsonUtil.generate(gen -> ViewMetadataParser.toJson(metadata, gen), pretty);
    }

    public static void toJson(ViewMetadata metadata, JsonGenerator gen) throws IOException {
        Preconditions.checkArgument((null != metadata ? 1 : 0) != 0, (Object)"Invalid view metadata: null");
        gen.writeStartObject();
        gen.writeStringField(VIEW_UUID, metadata.uuid());
        gen.writeNumberField(FORMAT_VERSION, metadata.formatVersion());
        gen.writeStringField(LOCATION, metadata.location());
        if (!metadata.properties().isEmpty()) {
            JsonUtil.writeStringMap(PROPERTIES, metadata.properties(), gen);
        }
        gen.writeArrayFieldStart(SCHEMAS);
        for (Schema schema : metadata.schemas()) {
            SchemaParser.toJson(schema, gen);
        }
        gen.writeEndArray();
        gen.writeNumberField(CURRENT_VERSION_ID, metadata.currentVersionId());
        gen.writeArrayFieldStart(VERSIONS);
        for (ViewVersion version : metadata.versions()) {
            ViewVersionParser.toJson(version, gen);
        }
        gen.writeEndArray();
        gen.writeArrayFieldStart(VERSION_LOG);
        for (ViewHistoryEntry viewHistoryEntry : metadata.history()) {
            ViewHistoryEntryParser.toJson(viewHistoryEntry, gen);
        }
        gen.writeEndArray();
        gen.writeEndObject();
    }

    public static ViewMetadata fromJson(String metadataLocation, String json) {
        return JsonUtil.parse(json, node -> ViewMetadataParser.fromJson(metadataLocation, node));
    }

    public static ViewMetadata fromJson(String json) {
        Preconditions.checkArgument((json != null ? 1 : 0) != 0, (Object)"Cannot parse view metadata from null string");
        return JsonUtil.parse(json, ViewMetadataParser::fromJson);
    }

    public static ViewMetadata fromJson(JsonNode json) {
        return ViewMetadataParser.fromJson(null, json);
    }

    public static ViewMetadata fromJson(String metadataLocation, JsonNode json) {
        Preconditions.checkArgument((json != null ? 1 : 0) != 0, (Object)"Cannot parse view metadata from null object");
        Preconditions.checkArgument((boolean)json.isObject(), (String)"Cannot parse view metadata from non-object: %s", (Object)json);
        String uuid = JsonUtil.getString(VIEW_UUID, json);
        int formatVersion = JsonUtil.getInt(FORMAT_VERSION, json);
        String location = JsonUtil.getString(LOCATION, json);
        ImmutableMap properties = json.has(PROPERTIES) ? JsonUtil.getStringMap(PROPERTIES, json) : ImmutableMap.of();
        JsonNode schemasNode = JsonUtil.get(SCHEMAS, json);
        Preconditions.checkArgument((boolean)schemasNode.isArray(), (String)"Cannot parse schemas from non-array: %s", (Object)schemasNode);
        ArrayList schemas = Lists.newArrayListWithExpectedSize((int)schemasNode.size());
        for (JsonNode schemaNode : schemasNode) {
            schemas.add(SchemaParser.fromJson(schemaNode));
        }
        int currentVersionId = JsonUtil.getInt(CURRENT_VERSION_ID, json);
        JsonNode versionsNode = JsonUtil.get(VERSIONS, json);
        Preconditions.checkArgument((boolean)versionsNode.isArray(), (String)"Cannot parse versions from non-array: %s", (Object)versionsNode);
        ArrayList versions = Lists.newArrayListWithExpectedSize((int)versionsNode.size());
        for (JsonNode versionNode : versionsNode) {
            versions.add(ViewVersionParser.fromJson(versionNode));
        }
        JsonNode versionLogNode = JsonUtil.get(VERSION_LOG, json);
        Preconditions.checkArgument((boolean)versionLogNode.isArray(), (String)"Cannot parse version-log from non-array: %s", (Object)versionLogNode);
        ArrayList historyEntries = Lists.newArrayListWithExpectedSize((int)versionLogNode.size());
        for (JsonNode vLog : versionLogNode) {
            historyEntries.add(ViewHistoryEntryParser.fromJson(vLog));
        }
        return ImmutableViewMetadata.of(uuid, formatVersion, location, schemas, currentVersionId, versions, historyEntries, (Map<String, String>)properties, (List<MetadataUpdate>)ImmutableList.of(), metadataLocation);
    }

    public static void overwrite(ViewMetadata metadata, OutputFile outputFile) {
        ViewMetadataParser.internalWrite(metadata, outputFile, true);
    }

    public static void write(ViewMetadata metadata, OutputFile outputFile) {
        ViewMetadataParser.internalWrite(metadata, outputFile, false);
    }

    public static ViewMetadata read(InputFile file) {
        ViewMetadata viewMetadata;
        block8: {
            TableMetadataParser.Codec codec = TableMetadataParser.Codec.fromFileName(file.location());
            GZIPInputStream is = codec == TableMetadataParser.Codec.GZIP ? new GZIPInputStream((InputStream)file.newStream()) : file.newStream();
            try {
                viewMetadata = ViewMetadataParser.fromJson(file.location(), (JsonNode)JsonUtil.mapper().readValue((InputStream)is, JsonNode.class));
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(String.format("Failed to read json file: %s", file.location()), e);
                }
            }
            ((InputStream)is).close();
        }
        return viewMetadata;
    }

    private static void internalWrite(ViewMetadata metadata, OutputFile outputFile, boolean overwrite) {
        boolean isGzip = TableMetadataParser.Codec.fromFileName(outputFile.location()) == TableMetadataParser.Codec.GZIP;
        PositionOutputStream stream = overwrite ? outputFile.createOrOverwrite() : outputFile.create();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)(isGzip ? new GZIPOutputStream((OutputStream)stream) : stream), StandardCharsets.UTF_8);){
            JsonGenerator generator = JsonUtil.factory().createGenerator((Writer)writer);
            ViewMetadataParser.toJson(metadata, generator);
            generator.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Failed to write json to file: %s", outputFile.location()), e);
        }
    }
}

