/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.io.Closeable;
import java.io.IOException;
import org.apache.iceberg.exceptions.RuntimeIOException;

public class Exceptions {
    private Exceptions() {
    }

    public static void close(Closeable closeable, boolean suppressExceptions) {
        block2: {
            try {
                closeable.close();
            }
            catch (IOException e) {
                if (suppressExceptions) break block2;
                throw new RuntimeIOException(e, "Failed calling close", new Object[0]);
            }
        }
    }

    public static <E extends Exception> E suppressExceptions(E alreadyThrown, Runnable run) {
        try {
            run.run();
        }
        catch (Exception e) {
            alreadyThrown.addSuppressed(e);
        }
        return alreadyThrown;
    }

    public static <E extends Exception> void suppressAndThrow(E alreadyThrown, Runnable run) throws E {
        throw Exceptions.suppressExceptions(alreadyThrown, run);
    }
}

