/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.encryption;

import org.apache.iceberg.encryption.AesGcmInputFile;
import org.apache.iceberg.encryption.AesGcmOutputStream;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.io.PositionOutputStream;

public class AesGcmOutputFile
implements OutputFile {
    private final OutputFile targetFile;
    private final byte[] dataKey;
    private final byte[] fileAADPrefix;

    public AesGcmOutputFile(OutputFile targetFile, byte[] dataKey, byte[] fileAADPrefix) {
        this.targetFile = targetFile;
        this.dataKey = dataKey;
        this.fileAADPrefix = fileAADPrefix;
    }

    public PositionOutputStream create() {
        return new AesGcmOutputStream(this.targetFile.create(), this.dataKey, this.fileAADPrefix);
    }

    public PositionOutputStream createOrOverwrite() {
        return new AesGcmOutputStream(this.targetFile.createOrOverwrite(), this.dataKey, this.fileAADPrefix);
    }

    public String location() {
        return this.targetFile.location();
    }

    public InputFile toInputFile() {
        return new AesGcmInputFile(this.targetFile.toInputFile(), this.dataKey, this.fileAADPrefix);
    }
}

