/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.encryption;

import org.apache.iceberg.encryption.AesGcmInputStream;
import org.apache.iceberg.encryption.Ciphers;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.SeekableInputStream;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

public class AesGcmInputFile
implements InputFile {
    private final InputFile sourceFile;
    private final byte[] dataKey;
    private final byte[] fileAADPrefix;
    private long plaintextLength;

    public AesGcmInputFile(InputFile sourceFile, byte[] dataKey, byte[] fileAADPrefix) {
        this.sourceFile = sourceFile;
        this.dataKey = dataKey;
        this.fileAADPrefix = fileAADPrefix;
        this.plaintextLength = -1L;
    }

    public long getLength() {
        if (this.plaintextLength == -1L) {
            this.plaintextLength = AesGcmInputStream.calculatePlaintextLength(this.sourceFile.getLength());
        }
        return this.plaintextLength;
    }

    public SeekableInputStream newStream() {
        long ciphertextLength = this.sourceFile.getLength();
        Preconditions.checkState((ciphertextLength >= (long)Ciphers.MIN_STREAM_LENGTH ? 1 : 0) != 0, (String)"Invalid encrypted stream: %d is shorter than the minimum possible stream length", (long)ciphertextLength);
        return new AesGcmInputStream(this.sourceFile.newStream(), ciphertextLength, this.dataKey, this.fileAADPrefix);
    }

    public String location() {
        return this.sourceFile.location();
    }

    public boolean exists() {
        return this.sourceFile.exists();
    }
}

