/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.catalog;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.SessionCatalog;
import org.apache.iceberg.catalog.SupportsNamespaces;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.NamespaceNotEmptyException;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;

public abstract class BaseSessionCatalog
implements SessionCatalog {
    private final Cache<String, Catalog> catalogs = Caffeine.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();
    private String name = null;
    private Map<String, String> properties = null;

    public void initialize(String catalogName, Map<String, String> props) {
        this.name = catalogName;
        this.properties = props;
    }

    public String name() {
        return this.name;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public Catalog asCatalog(SessionCatalog.SessionContext context) {
        return (Catalog)this.catalogs.get((Object)context.sessionId(), id -> new AsCatalog(context));
    }

    public <T> T withContext(SessionCatalog.SessionContext context, Function<Catalog, T> task) {
        return task.apply(this.asCatalog(context));
    }

    public class AsCatalog
    implements Catalog,
    SupportsNamespaces {
        private final SessionCatalog.SessionContext context;

        private AsCatalog(SessionCatalog.SessionContext context) {
            this.context = context;
        }

        public String name() {
            return BaseSessionCatalog.this.name();
        }

        public List<TableIdentifier> listTables(Namespace namespace) {
            return BaseSessionCatalog.this.listTables(this.context, namespace);
        }

        public Catalog.TableBuilder buildTable(TableIdentifier ident, Schema schema) {
            return BaseSessionCatalog.this.buildTable(this.context, ident, schema);
        }

        public Table registerTable(TableIdentifier ident, String metadataFileLocation) {
            return BaseSessionCatalog.this.registerTable(this.context, ident, metadataFileLocation);
        }

        public boolean tableExists(TableIdentifier ident) {
            return BaseSessionCatalog.this.tableExists(this.context, ident);
        }

        public Table loadTable(TableIdentifier ident) {
            return BaseSessionCatalog.this.loadTable(this.context, ident);
        }

        public boolean dropTable(TableIdentifier ident) {
            return BaseSessionCatalog.this.dropTable(this.context, ident);
        }

        public boolean dropTable(TableIdentifier ident, boolean purge) {
            if (purge) {
                return BaseSessionCatalog.this.purgeTable(this.context, ident);
            }
            return BaseSessionCatalog.this.dropTable(this.context, ident);
        }

        public void renameTable(TableIdentifier from, TableIdentifier to) {
            BaseSessionCatalog.this.renameTable(this.context, from, to);
        }

        public void invalidateTable(TableIdentifier ident) {
            BaseSessionCatalog.this.invalidateTable(this.context, ident);
        }

        public void createNamespace(Namespace namespace, Map<String, String> metadata) {
            BaseSessionCatalog.this.createNamespace(this.context, namespace, metadata);
        }

        public List<Namespace> listNamespaces(Namespace namespace) {
            return BaseSessionCatalog.this.listNamespaces(this.context, namespace);
        }

        public Map<String, String> loadNamespaceMetadata(Namespace namespace) {
            return BaseSessionCatalog.this.loadNamespaceMetadata(this.context, namespace);
        }

        public boolean dropNamespace(Namespace namespace) throws NamespaceNotEmptyException {
            return BaseSessionCatalog.this.dropNamespace(this.context, namespace);
        }

        public boolean setProperties(Namespace namespace, Map<String, String> updates) {
            return BaseSessionCatalog.this.updateNamespaceMetadata(this.context, namespace, updates, (Set)ImmutableSet.of());
        }

        public boolean removeProperties(Namespace namespace, Set<String> removals) {
            return BaseSessionCatalog.this.updateNamespaceMetadata(this.context, namespace, (Map)ImmutableMap.of(), removals);
        }

        public boolean namespaceExists(Namespace namespace) {
            return BaseSessionCatalog.this.namespaceExists(this.context, namespace);
        }
    }
}

