/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.BaseFilesTable;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.TableScanContext;
import org.apache.iceberg.io.CloseableIterable;

public class DataFilesTable
extends BaseFilesTable {
    DataFilesTable(Table table) {
        this(table, table.name() + ".data_files");
    }

    DataFilesTable(Table table, String name) {
        super(table, name);
    }

    public TableScan newScan() {
        return new DataFilesTableScan(this.table(), this.schema());
    }

    @Override
    MetadataTableType metadataTableType() {
        return MetadataTableType.DATA_FILES;
    }

    public static class DataFilesTableScan
    extends BaseFilesTable.BaseFilesTableScan {
        DataFilesTableScan(Table table, Schema schema) {
            super(table, schema, MetadataTableType.DATA_FILES);
        }

        DataFilesTableScan(Table table, Schema schema, TableScanContext context) {
            super(table, schema, MetadataTableType.DATA_FILES, context);
        }

        @Override
        protected TableScan newRefinedScan(Table table, Schema schema, TableScanContext context) {
            return new DataFilesTableScan(table, schema, context);
        }

        @Override
        protected CloseableIterable<ManifestFile> manifests() {
            return CloseableIterable.withNoopClose((Iterable)this.snapshot().dataManifests(this.table().io()));
        }
    }
}

