/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.alias;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.alias.CredentialProvider;
import org.apache.hadoop.security.alias.CredentialProviderFactory;

@InterfaceAudience.Private
public class UserProvider
extends CredentialProvider {
    public static final String SCHEME_NAME = "user";
    private final UserGroupInformation user = UserGroupInformation.getCurrentUser();
    private final Credentials credentials = this.user.getCredentials();

    private UserProvider() throws IOException {
    }

    @Override
    public boolean isTransient() {
        return true;
    }

    @Override
    public CredentialProvider.CredentialEntry getCredentialEntry(String alias) {
        byte[] bytes = this.credentials.getSecretKey(new Text(alias));
        if (bytes == null) {
            return null;
        }
        return new CredentialProvider.CredentialEntry(alias, new String(bytes, StandardCharsets.UTF_8).toCharArray());
    }

    @Override
    public CredentialProvider.CredentialEntry createCredentialEntry(String name, char[] credential) throws IOException {
        Text nameT = new Text(name);
        if (this.credentials.getSecretKey(nameT) != null) {
            throw new IOException("Credential " + name + " already exists in " + this);
        }
        this.credentials.addSecretKey(new Text(name), new String(credential).getBytes("UTF-8"));
        return new CredentialProvider.CredentialEntry(name, credential);
    }

    @Override
    public void deleteCredentialEntry(String name) throws IOException {
        byte[] cred = this.credentials.getSecretKey(new Text(name));
        if (cred == null) {
            throw new IOException("Credential " + name + " does not exist in " + this);
        }
        this.credentials.removeSecretKey(new Text(name));
    }

    public String toString() {
        return "user:///";
    }

    @Override
    public void flush() {
        this.user.addCredentials(this.credentials);
    }

    @Override
    public List<String> getAliases() throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        List<Text> aliases = this.credentials.getAllSecretKeys();
        for (Text key : aliases) {
            list.add(key.toString());
        }
        return list;
    }

    public static class Factory
    extends CredentialProviderFactory {
        @Override
        public CredentialProvider createProvider(URI providerName, Configuration conf) throws IOException {
            if (UserProvider.SCHEME_NAME.equals(providerName.getScheme())) {
                return new UserProvider();
            }
            return null;
        }
    }
}

