/*
 * Decompiled with CFR 0.152.
 */
package javolution.context;

import javolution.context.Context;
import javolution.util.FastMap;

public class LocalContext
extends Context {
    final FastMap _references = new FastMap();

    public static void enter() {
        Context.enter(LocalContext.class);
    }

    public static void exit() {
        Context.exit(LocalContext.class);
    }

    protected void enterAction() {
    }

    protected void exitAction() {
        this._references.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Reference<T>
    implements javolution.lang.Reference<T> {
        private T _defaultValue;
        private boolean _hasBeenLocallyOverriden;

        public Reference() {
            this(null);
        }

        public Reference(T defaultValue) {
            this._defaultValue = defaultValue;
        }

        @Override
        public final T get() {
            return this._hasBeenLocallyOverriden ? this.retrieveValue() : this._defaultValue;
        }

        private T retrieveValue() {
            for (Context ctx = Context.getCurrentContext(); ctx != null; ctx = ctx.getOuter()) {
                if (!(ctx instanceof LocalContext)) continue;
                LocalContext localContext = (LocalContext)ctx;
                Object value = localContext._references.get(this);
                if (value == null) continue;
                return (T)value;
            }
            return this._defaultValue;
        }

        @Override
        public void set(T value) {
            LocalContext ctx = Reference.getLocalContext();
            if (ctx != null) {
                FastMap references = ctx._references;
                references.put(this, value);
                this._hasBeenLocallyOverriden = true;
                return;
            }
            this._defaultValue = value;
        }

        public T getDefault() {
            return this._defaultValue;
        }

        public T getLocal() {
            LocalContext ctx = Reference.getLocalContext();
            return (T)(ctx != null ? ctx._references.get(this) : this._defaultValue);
        }

        public void setDefault(T defaultValue) {
            this._defaultValue = defaultValue;
        }

        public String toString() {
            return String.valueOf(this.get());
        }

        private static LocalContext getLocalContext() {
            for (Context ctx = Context.getCurrentContext(); ctx != null; ctx = ctx.getOuter()) {
                if (!(ctx instanceof LocalContext)) continue;
                return (LocalContext)ctx;
            }
            return null;
        }
    }
}

