/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.requests;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.json.JsonUtils;
import org.apache.gravitino.rest.RESTRequest;
import org.apache.gravitino.stats.StatisticValue;

@JsonDeserialize(builder=StatisticsUpdateRequestBuilder.class)
public class StatisticsUpdateRequest
implements RESTRequest {
    @JsonProperty(value="updates")
    @JsonSerialize(contentUsing=JsonUtils.StatisticValueSerializer.class)
    @JsonDeserialize(contentUsing=JsonUtils.StatisticValueDeserializer.class)
    Map<String, StatisticValue<?>> updates;

    public StatisticsUpdateRequest(Map<String, StatisticValue<?>> updates) {
        this.updates = updates;
    }

    public StatisticsUpdateRequest() {
        this(null);
    }

    @Override
    public void validate() throws IllegalArgumentException {
        Preconditions.checkArgument((this.updates != null && !this.updates.isEmpty() ? 1 : 0) != 0, (Object)"\"updates\" must not be null or empty");
        this.updates.forEach((name, value) -> {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)name), (Object)"statistic \"name\" must not be null or empty");
            Preconditions.checkArgument((value != null ? 1 : 0) != 0, (String)"statistic \"value\" for '%s' must not be null", (Object)name);
        });
    }

    public static StatisticsUpdateRequestBuilder builder() {
        return new StatisticsUpdateRequestBuilder();
    }

    public Map<String, StatisticValue<?>> getUpdates() {
        return this.updates;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StatisticsUpdateRequest)) {
            return false;
        }
        StatisticsUpdateRequest other = (StatisticsUpdateRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, StatisticValue<?>> this$updates = this.getUpdates();
        Map<String, StatisticValue<?>> other$updates = other.getUpdates();
        return !(this$updates == null ? other$updates != null : !((Object)this$updates).equals(other$updates));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StatisticsUpdateRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, StatisticValue<?>> $updates = this.getUpdates();
        result = result * 59 + ($updates == null ? 43 : ((Object)$updates).hashCode());
        return result;
    }

    public String toString() {
        return "StatisticsUpdateRequest(updates=" + String.valueOf(this.getUpdates()) + ")";
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class StatisticsUpdateRequestBuilder {
        private Map<String, StatisticValue<?>> updates;

        StatisticsUpdateRequestBuilder() {
        }

        @JsonProperty(value="updates")
        @JsonDeserialize(contentUsing=JsonUtils.StatisticValueDeserializer.class)
        public StatisticsUpdateRequestBuilder updates(Map<String, StatisticValue<?>> updates) {
            this.updates = updates;
            return this;
        }

        public StatisticsUpdateRequest build() {
            return new StatisticsUpdateRequest(this.updates);
        }

        public String toString() {
            return "StatisticsUpdateRequest.StatisticsUpdateRequestBuilder(updates=" + String.valueOf(this.updates) + ")";
        }
    }
}

