/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.file;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.annotation.Evolving;
import org.apache.gravitino.exceptions.FilesetAlreadyExistsException;
import org.apache.gravitino.exceptions.NoSuchFilesetException;
import org.apache.gravitino.exceptions.NoSuchLocationNameException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.file.Fileset;
import org.apache.gravitino.file.FilesetChange;

@Evolving
public interface FilesetCatalog {
    public NameIdentifier[] listFilesets(Namespace var1) throws NoSuchSchemaException;

    public Fileset loadFileset(NameIdentifier var1) throws NoSuchFilesetException;

    default public boolean filesetExists(NameIdentifier ident) {
        try {
            this.loadFileset(ident);
            return true;
        }
        catch (NoSuchFilesetException e) {
            return false;
        }
    }

    default public Fileset createFileset(NameIdentifier ident, String comment, Fileset.Type type, String storageLocation, Map<String, String> properties) throws NoSuchSchemaException, FilesetAlreadyExistsException {
        return this.createMultipleLocationFileset(ident, comment, type, (Map<String, String>)(storageLocation == null ? ImmutableMap.of() : ImmutableMap.of((Object)"unknown", (Object)storageLocation)), properties);
    }

    default public Fileset createMultipleLocationFileset(NameIdentifier ident, String comment, Fileset.Type type, Map<String, String> storageLocations, Map<String, String> properties) throws NoSuchSchemaException, FilesetAlreadyExistsException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Fileset alterFileset(NameIdentifier var1, FilesetChange ... var2) throws NoSuchFilesetException, IllegalArgumentException;

    public boolean dropFileset(NameIdentifier var1);

    default public String getFileLocation(NameIdentifier ident, String subPath) throws NoSuchFilesetException {
        return this.getFileLocation(ident, subPath, null);
    }

    default public String getFileLocation(NameIdentifier ident, String subPath, String locationName) throws NoSuchFilesetException, NoSuchLocationNameException {
        throw new UnsupportedOperationException("Not implemented");
    }
}

