/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server.authentication;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.gravitino.Config;
import org.apache.gravitino.Configs;
import org.apache.gravitino.auth.AuthenticatorType;
import org.apache.gravitino.server.authentication.Authenticator;
import org.apache.gravitino.server.authentication.KerberosAuthenticator;
import org.apache.gravitino.server.authentication.OAuth2TokenAuthenticator;
import org.apache.gravitino.server.authentication.SimpleAuthenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticatorFactory {
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticatorFactory.class);
    public static final ImmutableMap<String, String> AUTHENTICATORS = ImmutableMap.of((Object)AuthenticatorType.SIMPLE.name().toLowerCase(), (Object)SimpleAuthenticator.class.getCanonicalName(), (Object)AuthenticatorType.OAUTH.name().toLowerCase(), (Object)OAuth2TokenAuthenticator.class.getCanonicalName(), (Object)AuthenticatorType.KERBEROS.name().toLowerCase(), (Object)KerberosAuthenticator.class.getCanonicalName());

    private AuthenticatorFactory() {
    }

    public static List<Authenticator> createAuthenticators(Config config) {
        List authenticatorNames = (List)config.get(Configs.AUTHENTICATORS);
        ArrayList authenticators = Lists.newArrayList();
        for (String name : authenticatorNames) {
            String className = (String)AUTHENTICATORS.getOrDefault((Object)name, (Object)name);
            try {
                Authenticator authenticator = (Authenticator)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                authenticators.add(authenticator);
            }
            catch (Exception e) {
                LOG.error("Failed to create and initialize Authenticator by name {}.", (Object)name, (Object)e);
                throw new RuntimeException("Failed to create and initialize Authenticator: " + name, e);
            }
        }
        return authenticators;
    }
}

