/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.utils;

import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.exceptions.IllegalNamespaceException;

public class NamespaceUtil {
    private NamespaceUtil() {
    }

    public static Namespace ofMetalake() {
        return Namespace.empty();
    }

    public static Namespace ofCatalog(String metalake) {
        return Namespace.of((String[])new String[]{metalake});
    }

    public static Namespace ofSchema(String metalake, String catalog) {
        return Namespace.of((String[])new String[]{metalake, catalog});
    }

    public static Namespace ofTable(String metalake, String catalog, String schema) {
        return Namespace.of((String[])new String[]{metalake, catalog, schema});
    }

    public static Namespace ofTag(String metalake) {
        return Namespace.of((String[])new String[]{metalake, "system", "tag"});
    }

    public static Namespace ofPolicy(String metalake) {
        return Namespace.of((String[])new String[]{metalake, "system", "policy"});
    }

    public static Namespace ofUser(String metalake) {
        return Namespace.of((String[])new String[]{metalake, "system", "user"});
    }

    public static Namespace ofRole(String metalake) {
        return Namespace.of((String[])new String[]{metalake, "system", "role"});
    }

    public static Namespace ofGroup(String metalake) {
        return Namespace.of((String[])new String[]{metalake, "system", "group"});
    }

    public static Namespace ofColumn(String metalake, String catalog, String schema, String table) {
        return Namespace.of((String[])new String[]{metalake, catalog, schema, table});
    }

    public static Namespace ofFileset(String metalake, String catalog, String schema) {
        return Namespace.of((String[])new String[]{metalake, catalog, schema});
    }

    public static Namespace ofTopic(String metalake, String catalog, String schema) {
        return Namespace.of((String[])new String[]{metalake, catalog, schema});
    }

    public static Namespace ofModel(String metalake, String catalog, String schema) {
        return Namespace.of((String[])new String[]{metalake, catalog, schema});
    }

    public static Namespace ofModelVersion(String metalake, String catalog, String schema, String model) {
        return Namespace.of((String[])new String[]{metalake, catalog, schema, model});
    }

    public static Namespace ofJobTemplate(String metalake) {
        return Namespace.of((String[])new String[]{metalake, "system", "job_template"});
    }

    public static Namespace ofJob(String metalake) {
        return Namespace.of((String[])new String[]{metalake, "system", "job"});
    }

    public static Namespace toModelVersionNs(NameIdentifier modelIdent) {
        return NamespaceUtil.ofModelVersion(modelIdent.namespace().level(0), modelIdent.namespace().level(1), modelIdent.namespace().level(2), modelIdent.name());
    }

    public static void checkMetalake(Namespace namespace) {
        NamespaceUtil.check(namespace != null && namespace.isEmpty(), "Metalake namespace must be non-null and empty, the input namespace is %s", namespace);
    }

    public static void checkCatalog(Namespace namespace) {
        NamespaceUtil.check(namespace != null && namespace.length() == 1, "Catalog namespace must be non-null and have 1 level, the input namespace is %s", namespace);
    }

    public static void checkSchema(Namespace namespace) {
        NamespaceUtil.check(namespace != null && namespace.length() == 2, "Schema namespace must be non-null and have 2 levels, the input namespace is %s", namespace);
    }

    public static void checkTable(Namespace namespace) {
        NamespaceUtil.check(namespace != null && namespace.length() == 3, "Table namespace must be non-null and have 3 levels, the input namespace is %s", namespace);
    }

    public static void checkColumn(Namespace namespace) {
        NamespaceUtil.check(namespace != null && namespace.length() == 4, "Column namespace must be non-null and have 4 levels, the input namespace is %s", namespace);
    }

    public static void checkFileset(Namespace namespace) {
        NamespaceUtil.check(namespace != null && namespace.length() == 3, "Fileset namespace must be non-null and have 3 levels, the input namespace is %s", namespace);
    }

    public static void checkTopic(Namespace namespace) {
        NamespaceUtil.check(namespace != null && namespace.length() == 3, "Topic namespace must be non-null and have 3 levels, the input namespace is %s", namespace);
    }

    public static void checkModel(Namespace namespace) {
        NamespaceUtil.check(namespace != null && namespace.length() == 3, "Model namespace must be non-null and have 3 levels, the input namespace is %s", namespace);
    }

    public static void checkModelVersion(Namespace namespace) {
        NamespaceUtil.check(namespace != null && namespace.length() == 4, "Model version namespace must be non-null and have 4 levels, the input namespace is %s", namespace);
    }

    @FormatMethod
    public static void check(boolean expression, @FormatString String message, Object ... args) {
        if (!expression) {
            throw new IllegalNamespaceException(message, args);
        }
    }
}

