/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.service;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.MetadataObjects;
import org.apache.gravitino.meta.GenericEntity;
import org.apache.gravitino.storage.relational.mapper.CatalogMetaMapper;
import org.apache.gravitino.storage.relational.mapper.FilesetMetaMapper;
import org.apache.gravitino.storage.relational.mapper.MetalakeMetaMapper;
import org.apache.gravitino.storage.relational.mapper.ModelMetaMapper;
import org.apache.gravitino.storage.relational.mapper.SchemaMetaMapper;
import org.apache.gravitino.storage.relational.mapper.TableColumnMapper;
import org.apache.gravitino.storage.relational.mapper.TableMetaMapper;
import org.apache.gravitino.storage.relational.mapper.TopicMetaMapper;
import org.apache.gravitino.storage.relational.po.ColumnPO;
import org.apache.gravitino.storage.relational.po.FilesetPO;
import org.apache.gravitino.storage.relational.po.ModelPO;
import org.apache.gravitino.storage.relational.po.SchemaPO;
import org.apache.gravitino.storage.relational.po.TablePO;
import org.apache.gravitino.storage.relational.po.TopicPO;
import org.apache.gravitino.storage.relational.service.CatalogMetaService;
import org.apache.gravitino.storage.relational.service.FilesetMetaService;
import org.apache.gravitino.storage.relational.service.MetalakeMetaService;
import org.apache.gravitino.storage.relational.service.ModelMetaService;
import org.apache.gravitino.storage.relational.service.RoleMetaService;
import org.apache.gravitino.storage.relational.service.SchemaMetaService;
import org.apache.gravitino.storage.relational.service.TableColumnMetaService;
import org.apache.gravitino.storage.relational.service.TableMetaService;
import org.apache.gravitino.storage.relational.service.TopicMetaService;
import org.apache.gravitino.storage.relational.utils.SessionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataObjectService {
    private static final String DOT = ".";
    private static final Joiner DOT_JOINER = Joiner.on((String)".");
    private static final Splitter DOT_SPLITTER = Splitter.on((String)".");
    private static final Logger LOG = LoggerFactory.getLogger(MetadataObjectService.class);
    static final Map<MetadataObject.Type, Function<List<Long>, Map<Long, String>>> TYPE_TO_FULLNAME_FUNCTION_MAP = ImmutableMap.of((Object)MetadataObject.Type.METALAKE, MetadataObjectService::getMetalakeObjectsFullName, (Object)MetadataObject.Type.CATALOG, MetadataObjectService::getCatalogObjectsFullName, (Object)MetadataObject.Type.SCHEMA, MetadataObjectService::getSchemaObjectsFullName, (Object)MetadataObject.Type.TABLE, MetadataObjectService::getTableObjectsFullName, (Object)MetadataObject.Type.FILESET, MetadataObjectService::getFilesetObjectsFullName, (Object)MetadataObject.Type.MODEL, MetadataObjectService::getModelObjectsFullName, (Object)MetadataObject.Type.TOPIC, MetadataObjectService::getTopicObjectsFullName, (Object)MetadataObject.Type.COLUMN, MetadataObjectService::getColumnObjectsFullName);

    private MetadataObjectService() {
    }

    public static List<MetadataObject> fromGenericEntities(List<GenericEntity> entities) {
        if (entities == null || entities.isEmpty()) {
            return Lists.newArrayList();
        }
        Map groupIdsByType = entities.stream().collect(Collectors.groupingBy(GenericEntity::type, Collectors.mapping(GenericEntity::id, Collectors.toList())));
        ArrayList metadataObjects = Lists.newArrayList();
        for (Map.Entry entry : groupIdsByType.entrySet()) {
            MetadataObject.Type objectType = MetadataObject.Type.valueOf((String)entry.getKey().name());
            Map<Long, String> metadataObjectNames = TYPE_TO_FULLNAME_FUNCTION_MAP.get(objectType).apply(entry.getValue());
            for (Map.Entry<Long, String> metadataObjectName : metadataObjectNames.entrySet()) {
                String fullName = metadataObjectName.getValue();
                if (fullName == null) continue;
                metadataObjects.add(MetadataObjects.parse((String)fullName, (MetadataObject.Type)objectType));
            }
        }
        return metadataObjects;
    }

    public static long getMetadataObjectId(long metalakeId, String fullName, MetadataObject.Type type) {
        if (type == MetadataObject.Type.METALAKE) {
            return MetalakeMetaService.getInstance().getMetalakeIdByName(fullName);
        }
        if (type == MetadataObject.Type.ROLE) {
            return RoleMetaService.getInstance().getRoleIdByMetalakeIdAndName(metalakeId, fullName);
        }
        List names = DOT_SPLITTER.splitToList((CharSequence)fullName);
        long catalogId = CatalogMetaService.getInstance().getCatalogIdByMetalakeIdAndName(metalakeId, (String)names.get(0));
        if (type == MetadataObject.Type.CATALOG) {
            return catalogId;
        }
        long schemaId = SchemaMetaService.getInstance().getSchemaIdByCatalogIdAndName(catalogId, (String)names.get(1));
        if (type == MetadataObject.Type.SCHEMA) {
            return schemaId;
        }
        if (type == MetadataObject.Type.FILESET) {
            return FilesetMetaService.getInstance().getFilesetIdBySchemaIdAndName(schemaId, (String)names.get(2));
        }
        if (type == MetadataObject.Type.TOPIC) {
            return TopicMetaService.getInstance().getTopicIdBySchemaIdAndName(schemaId, (String)names.get(2));
        }
        if (type == MetadataObject.Type.MODEL) {
            return ModelMetaService.getInstance().getModelIdBySchemaIdAndModelName(schemaId, (String)names.get(2));
        }
        long tableId = TableMetaService.getInstance().getTableIdBySchemaIdAndName(schemaId, (String)names.get(2));
        if (type == MetadataObject.Type.TABLE) {
            return tableId;
        }
        if (type == MetadataObject.Type.COLUMN) {
            return TableColumnMetaService.getInstance().getColumnIdByTableIdAndName(tableId, (String)names.get(3));
        }
        throw new IllegalArgumentException(String.format("Doesn't support the type %s", type));
    }

    public static Map<Long, String> getMetalakeObjectsFullName(List<Long> metalakeIds) {
        List metalakePOs = SessionUtils.getWithoutCommit(MetalakeMetaMapper.class, mapper -> mapper.listMetalakePOsByMetalakeIds(metalakeIds));
        if (metalakePOs == null || metalakePOs.isEmpty()) {
            return new HashMap<Long, String>();
        }
        HashMap<Long, String> metalakeIdAndNameMap = new HashMap<Long, String>();
        metalakePOs.forEach(metalakePO -> metalakeIdAndNameMap.put(metalakePO.getMetalakeId(), metalakePO.getMetalakeName()));
        return metalakeIdAndNameMap;
    }

    public static Map<Long, String> getFilesetObjectsFullName(List<Long> filesetIds) {
        List filesetPOs = SessionUtils.getWithoutCommit(FilesetMetaMapper.class, mapper -> mapper.listFilesetPOsByFilesetIds(filesetIds));
        if (filesetPOs == null || filesetPOs.isEmpty()) {
            return new HashMap<Long, String>();
        }
        List<Long> schemaIds = filesetPOs.stream().map(FilesetPO::getSchemaId).collect(Collectors.toList());
        Map<Long, String> schemaIdAndNameMap = MetadataObjectService.getSchemaObjectsFullName(schemaIds);
        HashMap<Long, String> filesetIdAndNameMap = new HashMap<Long, String>();
        filesetPOs.forEach(filesetPO -> {
            String schemaName = schemaIdAndNameMap.getOrDefault(filesetPO.getSchemaId(), null);
            if (schemaName == null) {
                LOG.warn("The schema of fileset {} may be deleted", (Object)filesetPO.getFilesetId());
                filesetIdAndNameMap.put(filesetPO.getFilesetId(), null);
                return;
            }
            String fullName = DOT_JOINER.join((Object)schemaName, (Object)filesetPO.getFilesetName(), new Object[0]);
            filesetIdAndNameMap.put(filesetPO.getFilesetId(), fullName);
        });
        return filesetIdAndNameMap;
    }

    public static Map<Long, String> getModelObjectsFullName(List<Long> modelIds) {
        List modelPOs = SessionUtils.getWithoutCommit(ModelMetaMapper.class, mapper -> mapper.listModelPOsByModelIds(modelIds));
        if (modelPOs == null || modelPOs.isEmpty()) {
            return new HashMap<Long, String>();
        }
        List<Long> schemaIds = modelPOs.stream().map(ModelPO::getSchemaId).collect(Collectors.toList());
        Map<Long, String> schemaIdAndNameMap = MetadataObjectService.getSchemaObjectsFullName(schemaIds);
        HashMap<Long, String> modelIdAndNameMap = new HashMap<Long, String>();
        modelPOs.forEach(modelPO -> {
            String schemaName = schemaIdAndNameMap.getOrDefault(modelPO.getSchemaId(), null);
            if (schemaName == null) {
                LOG.warn("The schema of model {} may be deleted", (Object)modelPO.getModelId());
                modelIdAndNameMap.put(modelPO.getModelId(), null);
                return;
            }
            String fullName = DOT_JOINER.join((Object)schemaName, (Object)modelPO.getModelName(), new Object[0]);
            modelIdAndNameMap.put(modelPO.getModelId(), fullName);
        });
        return modelIdAndNameMap;
    }

    public static Map<Long, String> getTableObjectsFullName(List<Long> tableIds) {
        List tablePOs = SessionUtils.getWithoutCommit(TableMetaMapper.class, mapper -> mapper.listTablePOsByTableIds(tableIds));
        if (tablePOs == null || tablePOs.isEmpty()) {
            return new HashMap<Long, String>();
        }
        List<Long> schemaIds = tablePOs.stream().map(TablePO::getSchemaId).collect(Collectors.toList());
        Map<Long, String> schemaIdAndNameMap = MetadataObjectService.getSchemaObjectsFullName(schemaIds);
        HashMap<Long, String> tableIdAndNameMap = new HashMap<Long, String>();
        tablePOs.forEach(tablePO -> {
            String schemaName = schemaIdAndNameMap.getOrDefault(tablePO.getSchemaId(), null);
            if (schemaName == null) {
                LOG.warn("The schema of table {} may be deleted", (Object)tablePO.getTableId());
                tableIdAndNameMap.put(tablePO.getTableId(), null);
                return;
            }
            String fullName = DOT_JOINER.join((Object)schemaName, (Object)tablePO.getTableName(), new Object[0]);
            tableIdAndNameMap.put(tablePO.getTableId(), fullName);
        });
        return tableIdAndNameMap;
    }

    public static Map<Long, String> getColumnObjectsFullName(List<Long> columnsIds) {
        List columnPOs = SessionUtils.getWithoutCommit(TableColumnMapper.class, mapper -> mapper.listColumnPOsByColumnIds(columnsIds));
        if (columnPOs == null || columnPOs.isEmpty()) {
            return new HashMap<Long, String>();
        }
        List<Long> tableIds = columnPOs.stream().map(ColumnPO::getTableId).collect(Collectors.toList());
        Map<Long, String> tableIdAndNameMap = MetadataObjectService.getTableObjectsFullName(tableIds);
        HashMap<Long, String> columnIdAndNameMap = new HashMap<Long, String>();
        columnPOs.forEach(columnPO -> {
            String tableName = tableIdAndNameMap.getOrDefault(columnPO.getTableId(), null);
            if (tableName == null) {
                LOG.warn("The table '{}' of column '{}' may be deleted", (Object)columnPO.getTableId(), (Object)columnPO.getColumnId());
                columnIdAndNameMap.put(columnPO.getColumnId(), null);
                return;
            }
            String fullName = DOT_JOINER.join((Object)tableName, (Object)columnPO.getColumnName(), new Object[0]);
            columnIdAndNameMap.put(columnPO.getColumnId(), fullName);
        });
        return columnIdAndNameMap;
    }

    public static Map<Long, String> getTopicObjectsFullName(List<Long> topicIds) {
        List topicPOs = SessionUtils.getWithoutCommit(TopicMetaMapper.class, mapper -> mapper.listTopicPOsByTopicIds(topicIds));
        if (topicPOs == null || topicPOs.isEmpty()) {
            return new HashMap<Long, String>();
        }
        List<Long> schemaIds = topicPOs.stream().map(TopicPO::getSchemaId).collect(Collectors.toList());
        Map<Long, String> schemaIdAndNameMap = MetadataObjectService.getSchemaObjectsFullName(schemaIds);
        HashMap<Long, String> topicIdAndNameMap = new HashMap<Long, String>();
        topicPOs.forEach(topicPO -> {
            String schemaName = schemaIdAndNameMap.getOrDefault(topicPO.getSchemaId(), null);
            if (schemaName == null) {
                LOG.warn("The schema of topic {} may be deleted", (Object)topicPO.getTopicId());
                topicIdAndNameMap.put(topicPO.getTopicId(), null);
                return;
            }
            String fullName = DOT_JOINER.join((Object)schemaName, (Object)topicPO.getTopicName(), new Object[0]);
            topicIdAndNameMap.put(topicPO.getTopicId(), fullName);
        });
        return topicIdAndNameMap;
    }

    public static Map<Long, String> getCatalogObjectsFullName(List<Long> catalogIds) {
        List catalogPOs = SessionUtils.getWithoutCommit(CatalogMetaMapper.class, mapper -> mapper.listCatalogPOsByCatalogIds(catalogIds));
        if (catalogPOs == null || catalogPOs.isEmpty()) {
            return new HashMap<Long, String>();
        }
        HashMap<Long, String> catalogIdAndNameMap = new HashMap<Long, String>();
        catalogPOs.forEach(catalogPO -> catalogIdAndNameMap.put(catalogPO.getCatalogId(), catalogPO.getCatalogName()));
        return catalogIdAndNameMap;
    }

    public static Map<Long, String> getSchemaObjectsFullName(List<Long> schemaIds) {
        List schemaPOs = SessionUtils.getWithoutCommit(SchemaMetaMapper.class, mapper -> mapper.listSchemaPOsBySchemaIds(schemaIds));
        if (schemaPOs == null || schemaPOs.isEmpty()) {
            return new HashMap<Long, String>();
        }
        List<Long> catalogIds = schemaPOs.stream().map(SchemaPO::getCatalogId).collect(Collectors.toList());
        Map<Long, String> catalogIdAndNameMap = MetadataObjectService.getCatalogObjectsFullName(catalogIds);
        HashMap<Long, String> schemaIdAndNameMap = new HashMap<Long, String>();
        schemaPOs.forEach(schemaPO -> {
            String catalogName = catalogIdAndNameMap.getOrDefault(schemaPO.getCatalogId(), null);
            if (catalogName == null) {
                LOG.warn("The catalog of schema {} may be deleted", (Object)schemaPO.getSchemaId());
                schemaIdAndNameMap.put(schemaPO.getSchemaId(), null);
                return;
            }
            String fullName = DOT_JOINER.join((Object)catalogName, (Object)schemaPO.getSchemaName(), new Object[0]);
            schemaIdAndNameMap.put(schemaPO.getSchemaId(), fullName);
        });
        return schemaIdAndNameMap;
    }
}

