/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.gravitino.storage.relational.JDBCBackend;
import org.apache.gravitino.storage.relational.mapper.provider.base.CatalogMetaBaseSQLProvider;
import org.apache.gravitino.storage.relational.mapper.provider.postgresql.CatalogMetaPostgreSQLProvider;
import org.apache.gravitino.storage.relational.po.CatalogPO;
import org.apache.gravitino.storage.relational.session.SqlSessionFactoryHelper;
import org.apache.ibatis.annotations.Param;

public class CatalogMetaSQLProviderFactory {
    private static final Map<JDBCBackend.JDBCBackendType, CatalogMetaBaseSQLProvider> CATALOG_META_SQL_PROVIDER_MAP = ImmutableMap.of((Object)((Object)JDBCBackend.JDBCBackendType.MYSQL), (Object)new CatalogMetaMySQLProvider(), (Object)((Object)JDBCBackend.JDBCBackendType.H2), (Object)new CatalogMetaH2Provider(), (Object)((Object)JDBCBackend.JDBCBackendType.POSTGRESQL), (Object)new CatalogMetaPostgreSQLProvider());

    public static CatalogMetaBaseSQLProvider getProvider() {
        String databaseId = SqlSessionFactoryHelper.getInstance().getSqlSessionFactory().getConfiguration().getDatabaseId();
        JDBCBackend.JDBCBackendType jdbcBackendType = JDBCBackend.JDBCBackendType.fromString(databaseId);
        return CATALOG_META_SQL_PROVIDER_MAP.get((Object)jdbcBackendType);
    }

    public static String listCatalogPOsByMetalakeName(@Param(value="metalakeName") String metalakeName) {
        return CatalogMetaSQLProviderFactory.getProvider().listCatalogPOsByMetalakeName(metalakeName);
    }

    public static String listCatalogPOsByMetalakeId(@Param(value="metalakeId") Long metalakeId) {
        return CatalogMetaSQLProviderFactory.getProvider().listCatalogPOsByMetalakeId(metalakeId);
    }

    public static String listCatalogPOsByCatalogIds(@Param(value="catalogIds") List<Long> catalogIds) {
        return CatalogMetaSQLProviderFactory.getProvider().listCatalogPOsByCatalogIds(catalogIds);
    }

    public static String selectCatalogIdByName(@Param(value="metalakeName") String metalakeName, @Param(value="catalogName") String catalogName) {
        return CatalogMetaSQLProviderFactory.getProvider().selectCatalogIdByName(metalakeName, catalogName);
    }

    public static String selectCatalogIdByMetalakeIdAndName(@Param(value="metalakeId") Long metalakeId, @Param(value="catalogName") String name) {
        return CatalogMetaSQLProviderFactory.getProvider().selectCatalogIdByMetalakeIdAndName(metalakeId, name);
    }

    public static String selectCatalogMetaByMetalakeIdAndName(@Param(value="metalakeId") Long metalakeId, @Param(value="catalogName") String name) {
        return CatalogMetaSQLProviderFactory.getProvider().selectCatalogMetaByMetalakeIdAndName(metalakeId, name);
    }

    public static String selectCatalogMetaByName(@Param(value="metalakeName") String metalakeName, @Param(value="catalogName") String catalogName) {
        return CatalogMetaSQLProviderFactory.getProvider().selectCatalogMetaByName(metalakeName, catalogName);
    }

    public static String selectCatalogIdByMetalakeNameAndCatalogName(@Param(value="metalakeName") String metalakeName, @Param(value="catalogName") String catalogName) {
        return CatalogMetaSQLProviderFactory.getProvider().selectCatalogIdByMetalakeNameAndCatalogName(metalakeName, catalogName);
    }

    public static String selectCatalogMetaById(@Param(value="catalogId") Long catalogId) {
        return CatalogMetaSQLProviderFactory.getProvider().selectCatalogMetaById(catalogId);
    }

    public static String insertCatalogMeta(@Param(value="catalogMeta") CatalogPO catalogPO) {
        return CatalogMetaSQLProviderFactory.getProvider().insertCatalogMeta(catalogPO);
    }

    public static String insertCatalogMetaOnDuplicateKeyUpdate(@Param(value="catalogMeta") CatalogPO catalogPO) {
        return CatalogMetaSQLProviderFactory.getProvider().insertCatalogMetaOnDuplicateKeyUpdate(catalogPO);
    }

    public static String updateCatalogMeta(@Param(value="newCatalogMeta") CatalogPO newCatalogPO, @Param(value="oldCatalogMeta") CatalogPO oldCatalogPO) {
        return CatalogMetaSQLProviderFactory.getProvider().updateCatalogMeta(newCatalogPO, oldCatalogPO);
    }

    public static String softDeleteCatalogMetasByCatalogId(@Param(value="catalogId") Long catalogId) {
        return CatalogMetaSQLProviderFactory.getProvider().softDeleteCatalogMetasByCatalogId(catalogId);
    }

    public static String softDeleteCatalogMetasByMetalakeId(@Param(value="metalakeId") Long metalakeId) {
        return CatalogMetaSQLProviderFactory.getProvider().softDeleteCatalogMetasByMetalakeId(metalakeId);
    }

    public static String deleteCatalogMetasByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return CatalogMetaSQLProviderFactory.getProvider().deleteCatalogMetasByLegacyTimeline(legacyTimeline, limit);
    }

    static class CatalogMetaMySQLProvider
    extends CatalogMetaBaseSQLProvider {
        CatalogMetaMySQLProvider() {
        }
    }

    static class CatalogMetaH2Provider
    extends CatalogMetaBaseSQLProvider {
        CatalogMetaH2Provider() {
        }
    }
}

