/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.meta;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.gravitino.Audit;
import org.apache.gravitino.Auditable;
import org.apache.gravitino.Entity;
import org.apache.gravitino.Field;
import org.apache.gravitino.HasIdentifier;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.gravitino.meta.TableStatisticEntity;
import org.apache.gravitino.stats.StatisticValue;

public abstract class StatisticEntity
implements Entity,
HasIdentifier,
Auditable {
    public static final Field ID = Field.required("id", Long.class, "The unique identifier of the statistic entity.");
    public static final Field NAME = Field.required("name", String.class, "The name of the statistic entity.");
    public static final Field VALUE = Field.required("value", StatisticValue.class, "The value of the statistic entity.");
    public static final Field AUDIT_INFO = Field.required("audit_info", Audit.class, "The audit details of the statistic entity.");
    protected Long id;
    protected String name;
    protected StatisticValue<?> value;
    protected AuditInfo auditInfo;
    protected Namespace namespace;

    public Audit auditInfo() {
        return this.auditInfo;
    }

    @Override
    public Map<Field, Object> fields() {
        HashMap fields = Maps.newHashMap();
        fields.put(ID, this.id);
        fields.put(NAME, this.name);
        fields.put(VALUE, this.value);
        fields.put(AUDIT_INFO, this.auditInfo);
        return fields;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Long id() {
        return this.id;
    }

    @Override
    public Namespace namespace() {
        return this.namespace;
    }

    public StatisticValue<?> value() {
        return this.value;
    }

    public static Entity.EntityType getStatisticType(MetadataObject.Type type) {
        switch (type) {
            case TABLE: {
                return Entity.EntityType.TABLE_STATISTIC;
            }
        }
        throw new IllegalArgumentException("Unsupported metadata object type for statistics: " + String.valueOf(type));
    }

    public static <S extends StatisticEntityBuilder<S, E>, E extends StatisticEntity> S builder(Entity.EntityType type) {
        switch (type) {
            case TABLE_STATISTIC: {
                return (S)TableStatisticEntity.builder();
            }
        }
        throw new IllegalArgumentException("Unsupported statistic entity type: " + String.valueOf((Object)type));
    }

    public static abstract class StatisticEntityBuilder<SELF extends Builder<SELF, T>, T extends StatisticEntity>
    implements Builder<SELF, T> {
        protected Long id;
        protected String name;
        protected StatisticValue<?> value;
        protected AuditInfo auditInfo;
        protected Namespace namespace;

        public SELF withId(Long id) {
            this.id = id;
            return this.self();
        }

        public SELF withName(String name) {
            this.name = name;
            return this.self();
        }

        public SELF withValue(StatisticValue<?> value) {
            this.value = value;
            return this.self();
        }

        public SELF withAuditInfo(AuditInfo auditInfo) {
            this.auditInfo = auditInfo;
            return this.self();
        }

        public SELF withNamespace(Namespace namespace) {
            this.namespace = namespace;
            return this.self();
        }

        private SELF self() {
            return (SELF)this;
        }

        protected abstract T internalBuild();

        @Override
        public T build() {
            T t = this.internalBuild();
            return t;
        }
    }

    static interface Builder<SELF extends Builder<SELF, T>, T extends StatisticEntity> {
        public T build();
    }
}

