/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.meta;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.gravitino.Auditable;
import org.apache.gravitino.Entity;
import org.apache.gravitino.Field;
import org.apache.gravitino.HasIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.authorization.Group;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.gravitino.utils.CollectionUtils;

public class GroupEntity
implements Group,
Entity,
Auditable,
HasIdentifier {
    public static final Field ID = Field.required("id", Long.class, " The unique id of the group entity.");
    public static final Field NAME = Field.required("name", String.class, "The name of the group entity.");
    public static final Field ROLE_NAMES = Field.optional("role_names", List.class, "The role names of the group entity.");
    public static final Field ROLE_IDS = Field.optional("role_ids", List.class, "The role names of the group entity.");
    public static final Field AUDIT_INFO = Field.required("audit_info", AuditInfo.class, "The audit details of the group entity.");
    private Long id;
    private String name;
    private AuditInfo auditInfo;
    private List<String> roleNames;
    private List<Long> roleIds;
    private Namespace namespace;

    private GroupEntity() {
    }

    @Override
    public Map<Field, Object> fields() {
        HashMap fields = Maps.newHashMap();
        fields.put(ID, this.id);
        fields.put(NAME, this.name);
        fields.put(AUDIT_INFO, this.auditInfo);
        fields.put(ROLE_NAMES, this.roleNames);
        fields.put(ROLE_IDS, this.roleIds);
        return Collections.unmodifiableMap(fields);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Long id() {
        return this.id;
    }

    @Override
    public Entity.EntityType type() {
        return Entity.EntityType.GROUP;
    }

    @Override
    public Namespace namespace() {
        return this.namespace;
    }

    public AuditInfo auditInfo() {
        return this.auditInfo;
    }

    public List<String> roles() {
        return this.roleNames;
    }

    public List<String> roleNames() {
        return this.roleNames;
    }

    public List<Long> roleIds() {
        return this.roleIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GroupEntity)) {
            return false;
        }
        GroupEntity that = (GroupEntity)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.namespace, that.namespace) && Objects.equals(this.auditInfo, that.auditInfo) && CollectionUtils.isEqualCollection(this.roleNames, that.roleNames) && CollectionUtils.isEqualCollection(this.roleIds, that.roleIds);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.auditInfo, this.roleNames, this.roleIds);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final GroupEntity groupEntity = new GroupEntity();

        private Builder() {
        }

        public Builder withId(Long id) {
            this.groupEntity.id = id;
            return this;
        }

        public Builder withName(String name) {
            this.groupEntity.name = name;
            return this;
        }

        public Builder withAuditInfo(AuditInfo auditInfo) {
            this.groupEntity.auditInfo = auditInfo;
            return this;
        }

        public Builder withRoleNames(List<String> roles) {
            this.groupEntity.roleNames = roles;
            return this;
        }

        public Builder withRoleIds(List<Long> roleIds) {
            this.groupEntity.roleIds = roleIds;
            return this;
        }

        public Builder withNamespace(Namespace namespace) {
            this.groupEntity.namespace = namespace;
            return this;
        }

        public GroupEntity build() {
            this.groupEntity.validate();
            return this.groupEntity;
        }
    }
}

