/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.connector.capability;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.gravitino.annotation.Evolving;
import org.apache.gravitino.connector.capability.CapabilityResult;

@Evolving
public interface Capability {
    public static final Capability DEFAULT = new DefaultCapability();

    default public CapabilityResult columnNotNull() {
        return DEFAULT.columnNotNull();
    }

    default public CapabilityResult columnDefaultValue() {
        return DEFAULT.columnDefaultValue();
    }

    default public CapabilityResult caseSensitiveOnName(Scope scope) {
        return DEFAULT.caseSensitiveOnName(scope);
    }

    default public CapabilityResult specificationOnName(Scope scope, String name) {
        return DEFAULT.specificationOnName(scope, name);
    }

    default public CapabilityResult managedStorage(Scope scope) {
        return DEFAULT.managedStorage(scope);
    }

    public static enum Scope {
        SCHEMA,
        TABLE,
        COLUMN,
        FILESET,
        TOPIC,
        PARTITION,
        MODEL;

    }

    public static class DefaultCapability
    implements Capability {
        private static final Set<String> RESERVED_WORDS = ImmutableSet.of((Object)"*");
        private static final String DEFAULT_NAME_PATTERN = "^\\w[\\w/=-]{0,63}$";

        @Override
        public CapabilityResult columnNotNull() {
            return CapabilityResult.SUPPORTED;
        }

        @Override
        public CapabilityResult columnDefaultValue() {
            return CapabilityResult.SUPPORTED;
        }

        @Override
        public CapabilityResult caseSensitiveOnName(Scope scope) {
            return CapabilityResult.SUPPORTED;
        }

        @Override
        public CapabilityResult specificationOnName(Scope scope, String name) {
            if (RESERVED_WORDS.contains(name.toLowerCase())) {
                return CapabilityResult.unsupported(String.format("The %s name '%s' is reserved.", new Object[]{scope, name}));
            }
            if (!name.matches(DEFAULT_NAME_PATTERN)) {
                return CapabilityResult.unsupported(String.format("The %s name '%s' is illegal.", new Object[]{scope, name}));
            }
            return CapabilityResult.SUPPORTED;
        }

        @Override
        public CapabilityResult managedStorage(Scope scope) {
            return CapabilityResult.unsupported(String.format("The %s entity is not fully managed by Gravitino.", new Object[]{scope}));
        }
    }
}

