/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog;

import java.util.Arrays;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.catalog.CapabilityHelpers;
import org.apache.gravitino.catalog.CatalogManager;
import org.apache.gravitino.catalog.PartitionDispatcher;
import org.apache.gravitino.connector.capability.Capability;
import org.apache.gravitino.exceptions.NoSuchPartitionException;
import org.apache.gravitino.exceptions.PartitionAlreadyExistsException;
import org.apache.gravitino.rel.partitions.Partition;

public class PartitionNormalizeDispatcher
implements PartitionDispatcher {
    private final CatalogManager catalogManager;
    private final PartitionDispatcher dispatcher;

    public PartitionNormalizeDispatcher(PartitionDispatcher dispatcher, CatalogManager catalogManager) {
        this.dispatcher = dispatcher;
        this.catalogManager = catalogManager;
    }

    @Override
    public String[] listPartitionNames(NameIdentifier tableIdent) {
        Capability capabilities = CapabilityHelpers.getCapability(tableIdent, this.catalogManager);
        String[] partitionNames = this.dispatcher.listPartitionNames(CapabilityHelpers.applyCaseSensitive(tableIdent, Capability.Scope.TABLE, capabilities));
        return (String[])Arrays.stream(partitionNames).map(partitionName -> CapabilityHelpers.applyCaseSensitiveOnName(Capability.Scope.PARTITION, partitionName, capabilities)).toArray(String[]::new);
    }

    @Override
    public Partition[] listPartitions(NameIdentifier tableIdent) {
        Capability capabilities = CapabilityHelpers.getCapability(tableIdent, this.catalogManager);
        Partition[] partitions = this.dispatcher.listPartitions(CapabilityHelpers.applyCaseSensitive(tableIdent, Capability.Scope.TABLE, capabilities));
        return CapabilityHelpers.applyCaseSensitive(partitions, capabilities);
    }

    @Override
    public Partition getPartition(NameIdentifier tableIdent, String partitionName) throws NoSuchPartitionException {
        Capability capabilities = CapabilityHelpers.getCapability(tableIdent, this.catalogManager);
        return this.dispatcher.getPartition(CapabilityHelpers.applyCaseSensitive(tableIdent, Capability.Scope.TABLE, capabilities), CapabilityHelpers.applyCaseSensitiveOnName(Capability.Scope.PARTITION, partitionName, capabilities));
    }

    @Override
    public Partition addPartition(NameIdentifier tableIdent, Partition partition) throws PartitionAlreadyExistsException {
        Capability capabilities = CapabilityHelpers.getCapability(tableIdent, this.catalogManager);
        return this.dispatcher.addPartition(CapabilityHelpers.applyCaseSensitive(tableIdent, Capability.Scope.TABLE, capabilities), CapabilityHelpers.applyCaseSensitive(partition, capabilities));
    }

    @Override
    public boolean dropPartition(NameIdentifier tableIdent, String partitionName) {
        Capability capabilities = CapabilityHelpers.getCapability(tableIdent, this.catalogManager);
        return this.dispatcher.dropPartition(CapabilityHelpers.applyCaseSensitive(tableIdent, Capability.Scope.TABLE, capabilities), CapabilityHelpers.applyCaseSensitiveOnName(Capability.Scope.PARTITION, partitionName, capabilities));
    }

    @Override
    public boolean purgePartition(NameIdentifier tableIdent, String partitionName) throws UnsupportedOperationException {
        Capability capabilities = CapabilityHelpers.getCapability(tableIdent, this.catalogManager);
        return this.dispatcher.purgePartition(CapabilityHelpers.applyCaseSensitive(tableIdent, Capability.Scope.TABLE, capabilities), CapabilityHelpers.applyCaseSensitiveOnName(Capability.Scope.PARTITION, partitionName, capabilities));
    }
}

