/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.api.results;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.JobID;
import org.apache.flink.table.api.ResultKind;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.gateway.api.results.ResultSet;
import org.apache.flink.table.utils.print.RowDataToStringConverter;

@Internal
public class ResultSetImpl
implements ResultSet {
    private final ResultSet.ResultType resultType;
    @Nullable
    private final Long nextToken;
    private final ResolvedSchema resultSchema;
    private final List<RowData> data;
    private final RowDataToStringConverter converter;
    private final boolean isQueryResult;
    @Nullable
    private final JobID jobID;
    private final ResultKind resultKind;

    public ResultSetImpl(ResultSet.ResultType resultType, @Nullable Long nextToken, ResolvedSchema resultSchema, List<RowData> data, RowDataToStringConverter converter, boolean isQueryResult, @Nullable JobID jobID, ResultKind resultKind) {
        this.nextToken = nextToken;
        this.resultType = resultType;
        this.resultSchema = resultSchema;
        this.data = data;
        this.converter = converter;
        this.isQueryResult = isQueryResult;
        this.jobID = jobID;
        this.resultKind = resultKind;
    }

    @Override
    public ResultSet.ResultType getResultType() {
        return this.resultType;
    }

    @Override
    @Nullable
    public Long getNextToken() {
        return this.nextToken;
    }

    @Override
    public ResolvedSchema getResultSchema() {
        return this.resultSchema;
    }

    @Override
    public List<RowData> getData() {
        return this.data;
    }

    public RowDataToStringConverter getConverter() {
        return this.converter;
    }

    @Override
    public boolean isQueryResult() {
        return this.isQueryResult;
    }

    @Override
    public JobID getJobID() {
        return this.jobID;
    }

    @Override
    public ResultKind getResultKind() {
        return this.resultKind;
    }

    public String toString() {
        return String.format("ResultSet{\n  resultType=%s,\n  nextToken=%s,\n  resultSchema=%s,\n  data=[%s],\n  isQueryResult=%s,\n  jobId=%s,\n  resultKind=%s\n}", new Object[]{this.resultType, this.nextToken, this.resultSchema.toString(), this.data.stream().map(Object::toString).collect(Collectors.joining(",")), this.isQueryResult, this.jobID, this.resultKind});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResultSetImpl)) {
            return false;
        }
        ResultSetImpl resultSet = (ResultSetImpl)o;
        return this.resultType == resultSet.resultType && Objects.equals(this.nextToken, resultSet.nextToken) && Objects.equals(this.resultSchema, resultSet.resultSchema) && Objects.equals(this.data, resultSet.data) && this.isQueryResult == resultSet.isQueryResult && Objects.equals(this.jobID, resultSet.jobID) && this.resultKind == resultSet.resultKind;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.resultType, this.nextToken, this.resultSchema, this.data, this.isQueryResult, this.jobID, this.resultKind});
    }
}

