/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.table;

import java.util.List;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.file.table.FileSystemConnectorOptions;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.types.DataType;

abstract class AbstractFileSystemTable {
    final ObjectIdentifier tableIdentifier;
    final Configuration tableOptions;
    final DataType physicalRowDataType;
    final Path path;
    final String defaultPartName;
    List<String> partitionKeys;

    AbstractFileSystemTable(ObjectIdentifier tableIdentifier, DataType physicalRowDataType, List<String> partitionKeys, ReadableConfig tableOptions) {
        this.tableIdentifier = tableIdentifier;
        this.tableOptions = (Configuration)tableOptions;
        this.physicalRowDataType = physicalRowDataType;
        this.path = new Path((String)this.tableOptions.get(FileSystemConnectorOptions.PATH));
        this.defaultPartName = (String)this.tableOptions.get(FileSystemConnectorOptions.PARTITION_DEFAULT_NAME);
        this.partitionKeys = partitionKeys;
    }
}

