/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.dialogs.preferences;

import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.ldapbrowser.common.dialogs.preferences.Messages;
import org.apache.directory.studio.ldapbrowser.core.model.schema.AttributeValueEditorRelation;
import org.apache.directory.studio.valueeditors.ValueEditorManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class AttributeValueEditorDialog
extends Dialog {
    private AttributeValueEditorRelation relation;
    private SortedMap<String, ValueEditorManager.ValueEditorExtension> class2ValueEditorExtensionMap;
    private String[] attributeTypesAndOids;
    private SortedMap<String, String> veName2classMap;
    private AttributeValueEditorRelation returnRelation;
    private Combo typeOrOidCombo;
    private Combo valueEditorCombo;
    private Button okButton;

    public AttributeValueEditorDialog(Shell parentShell, AttributeValueEditorRelation relation, SortedMap<String, ValueEditorManager.ValueEditorExtension> class2ValueEditorExtensionMap, String[] attributeTypesAndOids) {
        super(parentShell);
        this.relation = relation;
        this.class2ValueEditorExtensionMap = class2ValueEditorExtensionMap;
        this.attributeTypesAndOids = attributeTypesAndOids;
        this.returnRelation = null;
        this.veName2classMap = new TreeMap<String, String>();
        for (ValueEditorManager.ValueEditorExtension vee : class2ValueEditorExtensionMap.values()) {
            this.veName2classMap.put(vee.name, vee.className);
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("AttributeValueEditorDialog.AttributeValueEditor"));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.validate();
    }

    protected void okPressed() {
        this.returnRelation = new AttributeValueEditorRelation(this.typeOrOidCombo.getText(), (String)this.veName2classMap.get(this.valueEditorCombo.getText()));
        super.okPressed();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite c = BaseWidgetUtils.createColumnContainer((Composite)composite, (int)2, (int)1);
        BaseWidgetUtils.createLabel((Composite)c, (String)Messages.getString("AttributeValueEditorDialog.AttributeTypeOrOID"), (int)1);
        this.typeOrOidCombo = BaseWidgetUtils.createCombo((Composite)c, (String[])this.attributeTypesAndOids, (int)-1, (int)1);
        if (this.relation != null && this.relation.getAttributeNumericOidOrType() != null) {
            this.typeOrOidCombo.setText(this.relation.getAttributeNumericOidOrType());
        }
        this.typeOrOidCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AttributeValueEditorDialog.this.validate();
            }
        });
        BaseWidgetUtils.createLabel((Composite)c, (String)Messages.getString("AttributeValueEditorDialog.ValueEditor"), (int)1);
        this.valueEditorCombo = BaseWidgetUtils.createReadonlyCombo((Composite)c, (String[])this.veName2classMap.keySet().toArray(new String[0]), (int)-1, (int)1);
        if (this.relation != null && this.relation.getValueEditorClassName() != null && this.class2ValueEditorExtensionMap.containsKey(this.relation.getValueEditorClassName())) {
            this.valueEditorCombo.setText(((ValueEditorManager.ValueEditorExtension)this.class2ValueEditorExtensionMap.get((Object)this.relation.getValueEditorClassName())).name);
        }
        this.valueEditorCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AttributeValueEditorDialog.this.validate();
            }
        });
        return composite;
    }

    private void validate() {
        this.okButton.setEnabled(!"".equals(this.valueEditorCombo.getText()) && !"".equals(this.typeOrOidCombo.getText()));
    }

    public AttributeValueEditorRelation getRelation() {
        return this.returnRelation;
    }
}

