/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.aciitemeditor.dialogs;

import java.util.Collection;
import org.apache.directory.api.ldap.aci.GrantAndDenial;
import org.apache.directory.api.ldap.aci.ProtectedItem;
import org.apache.directory.api.ldap.aci.UserPermission;
import org.apache.directory.studio.aciitemeditor.ACIItemValueWithContext;
import org.apache.directory.studio.aciitemeditor.Activator;
import org.apache.directory.studio.aciitemeditor.dialogs.Messages;
import org.apache.directory.studio.aciitemeditor.widgets.ACIItemGrantsAndDenialsComposite;
import org.apache.directory.studio.aciitemeditor.widgets.ACIItemProtectedItemsComposite;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;

public class UserPermissionDialog
extends Dialog {
    private ACIItemValueWithContext context;
    private UserPermission initialUserPermission;
    private UserPermission returnUserPermission;
    private Button precedenceCheckbox = null;
    private Spinner precedenceSpinner = null;
    private ACIItemProtectedItemsComposite protectedItemsComposite;
    private ACIItemGrantsAndDenialsComposite grantsAndDenialsComposite;

    public UserPermissionDialog(Shell parentShell, UserPermission initialUserPermission, ACIItemValueWithContext context) {
        super(parentShell);
        super.setShellStyle(super.getShellStyle() | 0x10);
        this.initialUserPermission = initialUserPermission;
        this.context = context;
        this.returnUserPermission = null;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.getString("UserPermissionDialog.dialog.text"));
        shell.setImage(Activator.getDefault().getImage(Messages.getString("UserPermissionDialog.dialog.icon")));
    }

    protected void okPressed() {
        try {
            Integer precedence = this.precedenceCheckbox.getSelection() ? Integer.valueOf(this.precedenceSpinner.getSelection()) : null;
            Collection<ProtectedItem> protectedItems = this.protectedItemsComposite.getProtectedItems();
            Collection<GrantAndDenial> grantsAndDenials = this.grantsAndDenialsComposite.getGrantsAndDenials();
            this.returnUserPermission = new UserPermission(precedence, grantsAndDenials, protectedItems);
            super.okPressed();
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("UserPermissionDialog.error.invalidUserPermission"), (String)e.getMessage());
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gd = new GridData(1808);
        gd.widthHint = this.convertHorizontalDLUsToPixels(300);
        gd.heightHint = this.convertVerticalDLUsToPixels(300) * 4 / 3;
        composite.setLayoutData((Object)gd);
        Composite spinnerComposite = new Composite(composite, 0);
        spinnerComposite.setLayout((Layout)new GridLayout(2, false));
        spinnerComposite.setLayoutData((Object)new GridData());
        this.precedenceCheckbox = new Button(spinnerComposite, 32);
        this.precedenceCheckbox.setText(Messages.getString("UserPermissionDialog.precedence.label"));
        this.precedenceCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UserPermissionDialog.this.precedenceSpinner.setEnabled(UserPermissionDialog.this.precedenceCheckbox.getSelection());
            }
        });
        this.precedenceSpinner = new Spinner(spinnerComposite, 2048);
        this.precedenceSpinner.setMinimum(0);
        this.precedenceSpinner.setMaximum(255);
        this.precedenceSpinner.setDigits(0);
        this.precedenceSpinner.setIncrement(1);
        this.precedenceSpinner.setPageIncrement(10);
        this.precedenceSpinner.setSelection(0);
        this.precedenceSpinner.setEnabled(false);
        GridData precedenceGridData = new GridData();
        precedenceGridData.grabExcessHorizontalSpace = true;
        precedenceGridData.verticalAlignment = 2;
        precedenceGridData.horizontalAlignment = 1;
        precedenceGridData.widthHint = 36;
        this.precedenceSpinner.setLayoutData((Object)precedenceGridData);
        this.protectedItemsComposite = new ACIItemProtectedItemsComposite(composite, 0);
        this.protectedItemsComposite.setContext(this.context);
        this.grantsAndDenialsComposite = new ACIItemGrantsAndDenialsComposite(composite, 0);
        if (this.initialUserPermission != null) {
            if (this.initialUserPermission.getPrecedence() != null && this.initialUserPermission.getPrecedence() > -1) {
                this.precedenceCheckbox.setSelection(true);
                this.precedenceSpinner.setEnabled(true);
                this.precedenceSpinner.setSelection(this.initialUserPermission.getPrecedence().intValue());
            }
            this.protectedItemsComposite.setProtectedItems(this.initialUserPermission.getProtectedItems());
            this.grantsAndDenialsComposite.setGrantsAndDenials(this.initialUserPermission.getGrantsAndDenials());
        }
        UserPermissionDialog.applyDialogFont((Control)composite);
        return composite;
    }

    public UserPermission getUserPermission() {
        return this.returnUserPermission;
    }
}

