/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.control;

import org.apache.torque.generator.control.ControllerState;
import org.apache.torque.generator.processor.string.StringProcessor;

public class TokenReplacer
implements StringProcessor {
    public static final char TOKEN_START_1 = '$';
    public static final char TOKEN_START_2 = '{';
    public static final char TOKEN_END = '}';
    public static final char ESCAPE = '\\';
    public static final String OPTION_PREFIX = "option";
    public static final char PREFIX_SEPARATOR = ':';
    private final ControllerState controllerState;

    public TokenReplacer(ControllerState controllerState) {
        if (controllerState == null) {
            throw new NullPointerException("controllerState must not be null");
        }
        this.controllerState = controllerState;
    }

    @Override
    public String process(String toProcess) {
        if (toProcess == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        StringBuilder tokenName = new StringBuilder();
        boolean escape = false;
        boolean inTokenStart = false;
        boolean inToken = false;
        for (char currentChar : toProcess.toCharArray()) {
            if (currentChar == '\\' && !escape) {
                escape = true;
                if (!inTokenStart) continue;
                result.append('$');
                inTokenStart = false;
                continue;
            }
            if (escape) {
                if (inToken) {
                    tokenName.append(currentChar);
                } else {
                    result.append(currentChar);
                }
                escape = false;
                continue;
            }
            escape = false;
            if (currentChar == '$' && !inTokenStart && !inToken) {
                inTokenStart = true;
                continue;
            }
            if (inTokenStart) {
                if (currentChar == '{') {
                    inTokenStart = false;
                    inToken = true;
                    continue;
                }
                result.append('$');
                result.append(currentChar);
                inTokenStart = false;
                continue;
            }
            if (currentChar == '}' && inToken) {
                result.append(this.resolveToken(tokenName.toString()));
                tokenName = new StringBuilder();
                inToken = false;
                continue;
            }
            if (inToken) {
                tokenName.append(currentChar);
                continue;
            }
            result.append(currentChar);
        }
        if (escape) {
            throw new IllegalArgumentException("Single escape character \\ encountered at end of String " + toProcess);
        }
        if (inTokenStart) {
            result.append('$');
        }
        if (inToken) {
            throw new IllegalArgumentException("Token end } missing at end of String " + toProcess);
        }
        return result.toString();
    }

    private String resolveToken(String tokenName) {
        String optionPrefixWithSep = "option:";
        if (!tokenName.startsWith(optionPrefixWithSep)) {
            throw new IllegalArgumentException("Token name must start with" + optionPrefixWithSep);
        }
        String optionName = tokenName.substring(optionPrefixWithSep.length());
        Object optionValue = this.controllerState.getOption(optionName);
        if (optionValue == null) {
            return "";
        }
        return optionValue.toString();
    }
}

