/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.util.HashSet;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.quantiles.QuantilesDoublesSketch;
import org.apache.datasketches.quantiles.QuantilesDoublesUnion;
import org.apache.datasketches.quantiles.UpdatableQuantilesDoublesSketch;
import org.apache.datasketches.quantilescommon.QuantilesDoublesSketchIteratorAPI;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DebugUnionTest {
    @Test
    public void test() {
        UpdatableQuantilesDoublesSketch dSketch;
        int n = 70000;
        int valueLimit = 1000;
        int numSketches = 3;
        int sketchK = 8;
        int unionK = 8;
        UpdatableQuantilesDoublesSketch[] sketchArr = new UpdatableQuantilesDoublesSketch[3];
        QuantilesDoublesSketch.setRandom((long)1L);
        HashSet<Double> set = new HashSet<Double>();
        for (int s = 0; s < 3; ++s) {
            sketchArr[s] = DebugUnionTest.buildHeapSketch(8, 70000, 1000, set);
        }
        QuantilesDoublesSketch.setRandom((long)1L);
        QuantilesDoublesUnion hUnion = QuantilesDoublesUnion.builder().setMaxK(8).build();
        for (int s = 0; s < 3; ++s) {
            hUnion.union((QuantilesDoublesSketch)sketchArr[s]);
        }
        UpdatableQuantilesDoublesSketch hSketch = hUnion.getResult();
        QuantilesDoublesSketch.setRandom((long)1L);
        try (Arena arena = Arena.ofConfined();){
            MemorySegment wseg = arena.allocate(10000000L);
            QuantilesDoublesUnion dUnion = QuantilesDoublesUnion.builder().setMaxK(8).build(wseg, null);
            for (int s = 0; s < 3; ++s) {
                dUnion.union((QuantilesDoublesSketch)sketchArr[s]);
            }
            dSketch = dUnion.getResult();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        int hCount = hSketch.getNumRetained();
        int dCount = dSketch.getNumRetained();
        Assert.assertEquals((int)hCount, (int)dCount);
        int hErrors = 0;
        int dErrors = 0;
        QuantilesDoublesSketchIteratorAPI hit = hSketch.iterator();
        QuantilesDoublesSketchIteratorAPI dit = dSketch.iterator();
        while (hit.next() && dit.next()) {
            double w;
            double v = hit.getQuantile();
            if (!set.contains(v)) {
                ++hErrors;
            }
            if (!set.contains(w = dit.getQuantile())) {
                ++dErrors;
            }
            Assert.assertEquals((double)v, (double)w, (double)0.0);
        }
        Assert.assertTrue((hErrors == 0 ? 1 : 0) != 0);
        Assert.assertTrue((dErrors == 0 ? 1 : 0) != 0);
        DebugUnionTest.println("HeapUnion  : Values: " + hCount + ", errors: " + hErrors);
        DebugUnionTest.println("DirectUnion: Values: " + dCount + ", errors: " + dErrors);
    }

    private static UpdatableQuantilesDoublesSketch buildHeapSketch(int k, int n, int valueLimit, HashSet<Double> set) {
        UpdatableQuantilesDoublesSketch uSk = QuantilesDoublesSketch.builder().setK(k).build();
        for (int i = 0; i < n; ++i) {
            double value = QuantilesDoublesSketch.rand.nextInt(valueLimit) + 1;
            uSk.update(value);
            set.add(value);
        }
        return uSk;
    }

    @Test
    public void printlnTest() {
        DebugUnionTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
        DebugUnionTest.print(s + Util.LS);
    }

    static void print(String s) {
    }
}

