/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.postoffice.impl;

import java.lang.ref.WeakReference;
import java.util.function.IntFunction;

final class IntegerCache {
    private static final boolean DISABLE_INTEGER_CACHE = Boolean.valueOf(System.getProperty("disable.integer.cache", Boolean.FALSE.toString()));
    private static WeakReference<Integer[]> INDEXES = null;

    IntegerCache() {
    }

    private static Integer[] ints(int size) {
        Integer[] indexes;
        WeakReference<Integer[]> indexesRef = INDEXES;
        Integer[] integerArray = indexes = indexesRef == null ? null : (Integer[])indexesRef.get();
        if (indexes != null && size <= indexes.length) {
            return indexes;
        }
        int newSize = size + (indexes == null ? 0 : size / 2);
        Integer[] newIndexes = new Integer[newSize];
        if (indexes != null) {
            System.arraycopy(indexes, 0, newIndexes, 0, indexes.length);
        }
        INDEXES = new WeakReference<Integer[]>(newIndexes);
        return newIndexes;
    }

    public static IntFunction<Integer> boxedInts(int size) {
        if (DISABLE_INTEGER_CACHE) {
            return Integer::valueOf;
        }
        Integer[] cachedInts = IntegerCache.ints(size);
        return index -> {
            Integer boxedInt = cachedInts[index];
            if (boxedInt == null) {
                cachedInts[index] = boxedInt = Integer.valueOf(index);
            }
            assert (boxedInt != null);
            return boxedInt;
        };
    }
}

