/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm.policy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.message.Message;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.policy.builder.jaxb.JaxbAssertion;
import org.apache.cxf.ws.rm.RMConfiguration;
import org.apache.cxf.ws.rm.RMUtils;
import org.apache.cxf.ws.rm.policy.RM10AssertionBuilder;
import org.apache.cxf.ws.rm.policy.RM12AssertionBuilder;
import org.apache.cxf.ws.rm.policy.RSPAssertionBuilder;
import org.apache.cxf.ws.rmp.v200502.RMAssertion;
import org.apache.neethi.builders.PrimitiveAssertion;

public final class RMPolicyUtilities {
    private static final List<QName> ASSERTION_NAMES = new ArrayList<QName>();

    private RMPolicyUtilities() {
    }

    public static RMConfiguration getRMConfiguration(RMConfiguration defaultValue, Message message) {
        RMConfiguration compatible = defaultValue;
        Collection<AssertionInfo> ais = RMPolicyUtilities.collectRMAssertions((AssertionInfoMap)message.get(AssertionInfoMap.class));
        for (AssertionInfo ai : ais) {
            PrimitiveAssertion assertion;
            if (ai.getAssertion() instanceof JaxbAssertion) {
                RMAssertion rma = (RMAssertion)((JaxbAssertion)ai.getAssertion()).getData();
                compatible = RMPolicyUtilities.intersect(rma, compatible);
                continue;
            }
            if (!(ai.getAssertion() instanceof PrimitiveAssertion) || !"http://docs.oasis-open.org/ws-rx/wsrmp/200702".equals((assertion = (PrimitiveAssertion)ai.getAssertion()).getName().getNamespaceURI())) continue;
            compatible = RMPolicyUtilities.intersect(assertion, compatible);
        }
        return compatible;
    }

    public static Collection<AssertionInfo> collectRMAssertions(AssertionInfoMap aim) {
        ArrayList<AssertionInfo> mergedAsserts = new ArrayList<AssertionInfo>();
        if (aim != null) {
            for (QName qn : ASSERTION_NAMES) {
                Collection ais = (Collection)aim.get((Object)qn);
                if (ais == null) continue;
                mergedAsserts.addAll(ais);
            }
        }
        return mergedAsserts;
    }

    public static boolean equals(RMAssertion a, RMAssertion b) {
        if (a == b) {
            return true;
        }
        Long aval = null;
        if (null != a.getInactivityTimeout()) {
            aval = a.getInactivityTimeout().getMilliseconds();
        }
        Long bval = null;
        if (null != b.getInactivityTimeout()) {
            bval = b.getInactivityTimeout().getMilliseconds();
        }
        if (!RMUtils.equalLongs(aval, bval)) {
            return false;
        }
        aval = null;
        if (null != a.getBaseRetransmissionInterval()) {
            aval = a.getBaseRetransmissionInterval().getMilliseconds();
        }
        bval = null;
        if (null != b.getBaseRetransmissionInterval()) {
            bval = b.getBaseRetransmissionInterval().getMilliseconds();
        }
        if (!RMUtils.equalLongs(aval, bval)) {
            return false;
        }
        aval = null;
        if (null != a.getAcknowledgementInterval()) {
            aval = a.getAcknowledgementInterval().getMilliseconds();
        }
        bval = null;
        if (null != b.getAcknowledgementInterval()) {
            bval = b.getAcknowledgementInterval().getMilliseconds();
        }
        if (!RMUtils.equalLongs(aval, bval)) {
            return false;
        }
        return null == a.getExponentialBackoff() ? null == b.getExponentialBackoff() : null != b.getExponentialBackoff();
    }

    public static boolean equals(RMConfiguration a, RMConfiguration b) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        if (a.getDeliveryAssurance() == null) {
            if (b.getDeliveryAssurance() != null) {
                return false;
            }
        } else {
            if (b.getDeliveryAssurance() == null) {
                return false;
            }
            if (a.getDeliveryAssurance() != b.getDeliveryAssurance()) {
                return false;
            }
        }
        if (a.getRM10AddressingNamespace() == null) {
            if (b.getRM10AddressingNamespace() != null) {
                return false;
            }
        } else {
            if (b.getRM10AddressingNamespace() == null) {
                return false;
            }
            if (!RMUtils.equalStrings(a.getRM10AddressingNamespace(), b.getRM10AddressingNamespace())) {
                return false;
            }
        }
        if (!RMUtils.equalStrings(a.getRMNamespace(), b.getRMNamespace())) {
            return false;
        }
        return a.isInOrder() == b.isInOrder() && a.isExponentialBackoff() == b.isExponentialBackoff() && a.isSequenceSTRRequired() == b.isSequenceSTRRequired() && a.isSequenceTransportSecurityRequired() == b.isSequenceTransportSecurityRequired() && RMUtils.equalLongs(a.getAcknowledgementInterval(), b.getAcknowledgementInterval()) && RMUtils.equalLongs(a.getBaseRetransmissionInterval(), b.getBaseRetransmissionInterval()) && RMUtils.equalLongs(a.getInactivityTimeout(), b.getInactivityTimeout());
    }

    public static RMConfiguration intersect(RMAssertion rma, RMConfiguration cfg) {
        Long use;
        if (RMPolicyUtilities.isCompatible(rma, cfg)) {
            return cfg;
        }
        RMConfiguration compatible = new RMConfiguration(cfg);
        Long aval = cfg.getInactivityTimeout();
        Long bval = null;
        if (null != rma.getInactivityTimeout()) {
            bval = rma.getInactivityTimeout().getMilliseconds();
        }
        if (null != aval || null != bval) {
            use = bval != null ? bval : aval;
            compatible.setInactivityTimeout(use);
        }
        aval = cfg.getBaseRetransmissionInterval();
        bval = null;
        if (null != rma.getBaseRetransmissionInterval()) {
            bval = rma.getBaseRetransmissionInterval().getMilliseconds();
        }
        if (null != aval || null != bval) {
            use = bval != null ? bval : aval;
            compatible.setBaseRetransmissionInterval(use);
        }
        aval = cfg.getAcknowledgementInterval();
        bval = null;
        if (null != rma.getAcknowledgementInterval()) {
            bval = rma.getAcknowledgementInterval().getMilliseconds();
        }
        if (null != aval || null != bval) {
            use = bval != null ? bval : aval;
            compatible.setAcknowledgementInterval(use);
        }
        if (cfg.isExponentialBackoff() || null != rma.getExponentialBackoff()) {
            compatible.setExponentialBackoff(true);
        }
        return compatible;
    }

    public static boolean isCompatible(RMAssertion asser, RMConfiguration cfg) {
        Long aval = null;
        if (null != asser.getInactivityTimeout()) {
            aval = asser.getInactivityTimeout().getMilliseconds();
        }
        if (!RMUtils.equalLongs(cfg.getInactivityTimeout(), aval)) {
            return false;
        }
        aval = null;
        if (null != asser.getBaseRetransmissionInterval()) {
            aval = asser.getBaseRetransmissionInterval().getMilliseconds();
        }
        if (!RMUtils.equalLongs(cfg.getBaseRetransmissionInterval(), aval)) {
            return false;
        }
        aval = null;
        if (null != asser.getAcknowledgementInterval()) {
            aval = asser.getAcknowledgementInterval().getMilliseconds();
        }
        if (!RMUtils.equalLongs(cfg.getAcknowledgementInterval(), aval)) {
            return false;
        }
        return cfg.isExponentialBackoff() ? null == asser.getExponentialBackoff() : null != asser.getExponentialBackoff();
    }

    public static RMConfiguration intersect(PrimitiveAssertion rma, RMConfiguration cfg) {
        if (RMPolicyUtilities.isCompatible(rma, cfg)) {
            return cfg;
        }
        RMConfiguration compatible = new RMConfiguration(cfg);
        String lname = rma.getName().getLocalPart();
        if ("RMAssertion".equals(lname)) {
            compatible.setRMNamespace("http://docs.oasis-open.org/ws-rx/wsrm/200702");
        } else if ("SequenceSTR".equals(lname)) {
            compatible.setSequenceSTRRequired(true);
        } else if ("SequenceTransportSecurity".equals(lname)) {
            compatible.setSequenceTransportSecurityRequired(true);
        } else if ("ExactlyOnce".equals(lname)) {
            compatible.setDeliveryAssurance(RMConfiguration.DeliveryAssurance.EXACTLY_ONCE);
        } else if ("AtLeastOnce".equals(lname)) {
            compatible.setDeliveryAssurance(RMConfiguration.DeliveryAssurance.AT_LEAST_ONCE);
        } else if ("AtMostOnce".equals(lname)) {
            compatible.setDeliveryAssurance(RMConfiguration.DeliveryAssurance.AT_MOST_ONCE);
        } else if ("InOrder".equals(lname)) {
            compatible.setInOrder(true);
        }
        return compatible;
    }

    public static boolean isCompatible(PrimitiveAssertion rma, RMConfiguration cfg) {
        String lname = rma.getName().getLocalPart();
        boolean compatible = true;
        if ("RMAssertion".equals(lname)) {
            compatible = "http://docs.oasis-open.org/ws-rx/wsrmp/200702".equals(cfg.getRMNamespace());
        } else if ("SequenceSTR".equals(lname)) {
            compatible = cfg.isSequenceSTRRequired();
        } else if ("SequenceTransportSecurity".equals(lname)) {
            compatible = cfg.isSequenceTransportSecurityRequired();
        } else if ("ExactlyOnce".equals(lname)) {
            compatible = cfg.getDeliveryAssurance() == RMConfiguration.DeliveryAssurance.EXACTLY_ONCE;
        } else if ("AtLeastOnce".equals(lname)) {
            compatible = cfg.getDeliveryAssurance() == RMConfiguration.DeliveryAssurance.AT_LEAST_ONCE;
        } else if ("AtMostOnce".equals(lname)) {
            compatible = cfg.getDeliveryAssurance() == RMConfiguration.DeliveryAssurance.AT_MOST_ONCE;
        } else if ("InOrder".equals(lname)) {
            compatible = cfg.isInOrder();
        }
        return compatible;
    }

    static {
        ASSERTION_NAMES.addAll(RM10AssertionBuilder.KNOWN_ELEMENTS);
        for (QName qn : RM12AssertionBuilder.KNOWN_ELEMENTS) {
            ASSERTION_NAMES.add(qn);
        }
        ASSERTION_NAMES.add(RSPAssertionBuilder.CONFORMANT_QNAME);
    }
}

