/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.scripting;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.primitive.DeprecationSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EvaluableScript
extends AbstractInitializableComponent {
    @Nonnull
    @NotEmpty
    private String scriptLanguage = "javascript";
    @NonnullAfterInit
    @NotEmpty
    private String script;
    @Nullable
    private ScriptEngine scriptEngine;
    @Nullable
    private CompiledScript compiledScript;
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(EvaluableScript.class);

    public EvaluableScript() {
    }

    @Deprecated(forRemoval=true, since="8.1.0")
    public EvaluableScript(@ParameterName(name="engineName") @Nonnull @NotEmpty String engineName, @ParameterName(name="scriptSource") @Nonnull @NotEmpty String scriptSource) throws ScriptException {
        DeprecationSupport.warnOnce(DeprecationSupport.ObjectType.METHOD, "EvaluableScript(parameters...)", null, "by using the setters");
        this.scriptLanguage = Constraint.isNotNull(StringSupport.trimOrNull(engineName), "Scripting language can not be null or empty");
        this.script = Constraint.isNotNull(StringSupport.trimOrNull(scriptSource), "Script source can not be null or empty");
        this.initializeWithScriptException();
    }

    @Deprecated(forRemoval=true, since="8.1.0")
    public EvaluableScript(@ParameterName(name="scriptSource") @Nonnull @NotEmpty String scriptSource) throws ScriptException {
        this("javascript", scriptSource);
    }

    @Deprecated(forRemoval=true, since="8.1.0")
    public EvaluableScript(@ParameterName(name="engineName") @Nonnull @NotEmpty String engineName, @ParameterName(name="scriptSource") @Nonnull Resource scriptSource) throws ScriptException {
        DeprecationSupport.warnOnce(DeprecationSupport.ObjectType.METHOD, "EvaluableScript(parameters...)", null, "by using the setters");
        this.scriptLanguage = Constraint.isNotNull(StringSupport.trimOrNull(engineName), "Scripting language can not be null or empty");
        try (InputStream in = Constraint.isNotNull(scriptSource, "Script source can not be null or empty").getInputStream();){
            this.script = StringSupport.inputStreamToString(in, null);
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
        this.initializeWithScriptException();
    }

    @Deprecated(forRemoval=true, since="8.1.0")
    public EvaluableScript(@ParameterName(name="scriptSource") @Nonnull Resource scriptSource) throws ScriptException {
        this("javascript", scriptSource);
    }

    @Deprecated(forRemoval=true, since="8.1.0")
    public EvaluableScript(@ParameterName(name="engineName") @Nonnull @NotEmpty String engineName, @ParameterName(name="scriptSource") @Nonnull InputStream scriptSource) throws ScriptException {
        DeprecationSupport.warnOnce(DeprecationSupport.ObjectType.METHOD, "EvaluableScript(parameters...)", null, "by using the setters");
        this.scriptLanguage = Constraint.isNotNull(StringSupport.trimOrNull(engineName), "Scripting language can not be null or empty");
        try {
            this.script = StringSupport.inputStreamToString(Constraint.isNotNull(scriptSource, "Script source can not be null or empty"), null);
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
        this.initializeWithScriptException();
    }

    @Deprecated(forRemoval=true, since="8.1.0")
    public EvaluableScript(@ParameterName(name="scriptSource") @Nonnull InputStream scriptSource) throws ScriptException {
        this("javascript", scriptSource);
    }

    @Deprecated(forRemoval=true, since="8.1.0")
    public EvaluableScript(@ParameterName(name="engineName") @Nonnull @NotEmpty String engineName, @ParameterName(name="scriptSource") @Nonnull File scriptSource) throws ScriptException {
        DeprecationSupport.warnOnce(DeprecationSupport.ObjectType.METHOD, "EvaluableScript(parameters...)", null, "by using the setters");
        this.scriptLanguage = Constraint.isNotNull(StringSupport.trimOrNull(engineName), "Scripting language can not be null or empty");
        Constraint.isNotNull(scriptSource, "Script source file can not be null");
        if (!scriptSource.exists()) {
            throw new ScriptException("Script source file " + scriptSource.getAbsolutePath() + " does not exist");
        }
        if (!scriptSource.canRead()) {
            throw new ScriptException("Script source file " + scriptSource.getAbsolutePath() + " exists but is not readable");
        }
        try {
            this.script = Constraint.isNotNull(StringSupport.trimOrNull(Files.asCharSource((File)scriptSource, (Charset)Charset.defaultCharset()).read()), "Script source cannot be empty");
        }
        catch (IOException e) {
            throw new ScriptException("Unable to read data from source file " + scriptSource.getAbsolutePath());
        }
        this.initializeWithScriptException();
    }

    @Deprecated(forRemoval=true, since="8.1.0")
    public EvaluableScript(@ParameterName(name="scriptSource") @Nonnull File scriptSource) throws ScriptException {
        this("javascript", scriptSource);
    }

    @Nonnull
    @NotEmpty
    public String getScript() {
        return this.script;
    }

    @Nonnull
    @NotEmpty
    public void setScript(@Nonnull @NotEmpty String what) {
        this.script = Constraint.isNotNull(StringSupport.trimOrNull(what), "Script must not be null");
        if ("".equals(this.script)) {
            throw new ConstraintViolationException("Script must be non-empty");
        }
    }

    @Nonnull
    @NotEmpty
    public void setScript(@Nonnull InputStream scriptSource) throws IOException {
        Constraint.isNotNull(scriptSource, "Script source should not be null");
        this.script = StringSupport.inputStreamToString(Constraint.isNotNull(scriptSource, "Script source can not be null or empty"), null);
    }

    @Nonnull
    @NotEmpty
    public void setScript(@Nonnull File scriptSource) throws IOException {
        Constraint.isNotNull(scriptSource, "Script source should not be null");
        if (!scriptSource.exists()) {
            throw new IOException("Script source file " + scriptSource.getAbsolutePath() + " does not exist");
        }
        if (!scriptSource.canRead()) {
            throw new IOException("Script source file " + scriptSource.getAbsolutePath() + " exists but is not readable");
        }
        this.script = Constraint.isNotNull(StringSupport.trimOrNull(Files.asCharSource((File)scriptSource, (Charset)Charset.defaultCharset()).read()), "Script source cannot be empty");
    }

    @Nonnull
    @NotEmpty
    public void setScript(@Nonnull Resource scriptSource) throws IOException {
        Constraint.isNotNull(scriptSource, "Script source should not be null");
        this.setScript(Constraint.isNotNull(scriptSource, "Script source can not be null or empty").getInputStream());
    }

    @Nonnull
    @NotEmpty
    public String getScriptLanguage() {
        return this.scriptLanguage;
    }

    @Nonnull
    @NotEmpty
    public void setEngineName(@Nonnull @NotEmpty String what) {
        this.scriptLanguage = Constraint.isNotNull(StringSupport.trimOrNull(what), "Language must not be null");
    }

    @Nullable
    public Object eval(@Nonnull Bindings scriptBindings) throws ScriptException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException(this);
        if (this.compiledScript != null) {
            return this.compiledScript.eval(scriptBindings);
        }
        return this.scriptEngine.eval(this.script, scriptBindings);
    }

    @Nullable
    public Object eval(@Nonnull ScriptContext scriptContext) throws ScriptException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException(this);
        if (this.compiledScript != null) {
            return this.compiledScript.eval(scriptContext);
        }
        return this.scriptEngine.eval(this.script, scriptContext);
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        if ("".equals(this.scriptLanguage)) {
            throw new ComponentInitializationException("Language must be non-empty");
        }
        if ("".equals(this.script)) {
            throw new ComponentInitializationException("Sanguage must be non-empty");
        }
        ScriptEngineManager engineManager = new ScriptEngineManager();
        this.scriptEngine = engineManager.getEngineByName(this.scriptLanguage);
        if (this.scriptEngine == null) {
            this.log.debug("Native support for {} not found, trying shibboleth-{}", (Object)this.scriptLanguage, (Object)this.scriptLanguage);
            this.scriptEngine = engineManager.getEngineByName("shibboleth-" + this.scriptLanguage);
        }
        Constraint.isNotNull(this.scriptEngine, "No scripting engine associated with scripting language " + this.scriptLanguage);
        if (this.scriptEngine instanceof Compilable) {
            try {
                this.compiledScript = ((Compilable)((Object)this.scriptEngine)).compile(this.script);
            }
            catch (ScriptException e) {
                throw new ComponentInitializationException(e);
            }
        } else {
            this.compiledScript = null;
        }
    }

    @Deprecated(forRemoval=true, since="8.1.0")
    public void initializeWithScriptException() throws ScriptException {
        try {
            this.initialize();
        }
        catch (ComponentInitializationException e) {
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof ScriptException) {
                throw (ScriptException)cause;
            }
            throw new ScriptException(e);
        }
    }
}

